/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
/**
 * @since 1.6.0
 */
export class IxActionCard {
  constructor() {
    this.variant = 'insight';
    this.icon = undefined;
    this.heading = undefined;
    this.subheading = undefined;
    this.selected = false;
  }
  render() {
    return (h(Host, { class: {
        selected: this.selected,
      } }, h("ix-card", { variant: this.variant, class: 'pointer' }, h("ix-card-content", null, this.icon ? (h("ix-icon", { class: 'icon', name: this.icon, size: "24" })) : (''), this.heading ? (h("ix-typography", { variant: "large-title" }, this.heading)) : (''), this.subheading ? (h("ix-typography", { variant: "default-title-single", color: this.variant === 'insight' ? 'soft' : undefined }, this.subheading)) : null, h("slot", null)))));
  }
  static get is() { return "ix-action-card"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["action-card.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["action-card.css"]
    };
  }
  static get properties() {
    return {
      "variant": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "ActionCardVariant",
          "resolved": "\"alarm\" | \"critical\" | \"info\" | \"insight\" | \"neutral\" | \"notification\" | \"success\" | \"warning\"",
          "references": {
            "ActionCardVariant": {
              "location": "local",
              "path": "/__w/ix/ix/packages/core/src/components/action-card/action-card.tsx"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card variant"
        },
        "attribute": "variant",
        "reflect": false,
        "defaultValue": "'insight'"
      },
      "icon": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string | undefined",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card icon"
        },
        "attribute": "icon",
        "reflect": false,
        "defaultValue": "undefined"
      },
      "heading": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card heading"
        },
        "attribute": "heading",
        "reflect": false
      },
      "subheading": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card subheading"
        },
        "attribute": "subheading",
        "reflect": false
      },
      "selected": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card selection"
        },
        "attribute": "selected",
        "reflect": false,
        "defaultValue": "false"
      }
    };
  }
}
//# sourceMappingURL=action-card.js.map
