/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
export class AnimatedTab {
  constructor() {
    this.icon = undefined;
    this.count = undefined;
  }
  render() {
    return (h(Host, null, h("slot", null)));
  }
  static get is() { return "ix-animated-tab"; }
  static get encapsulation() { return "scoped"; }
  static get originalStyleUrls() {
    return {
      "$": ["animated-tab.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["animated-tab.css"]
    };
  }
  static get properties() {
    return {
      "icon": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Icon of the tab"
        },
        "attribute": "icon",
        "reflect": false
      },
      "count": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Show notification number"
        },
        "attribute": "count",
        "reflect": true
      }
    };
  }
}
//# sourceMappingURL=animated-tab.js.map
