/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
import { menuController } from '../utils/menu-service/menu-service';
import { hostContext, isBasicNavigationLayout } from '../utils/screen/context';
import { screenMode } from '../utils/screen/service';
export class ApplicationHeader {
  constructor() {
    this.name = undefined;
    this.mode = 'desktop';
    this.menuExpanded = false;
  }
  componentWillLoad() {
    const layout = hostContext('ix-basic-navigation', this.host);
    if (isBasicNavigationLayout(layout)) {
      this.modeDisposable = screenMode.onChange.on((mode) => (this.mode = mode));
      this.mode = screenMode.mode;
      this.menuDisposable = menuController.expandChange.on((show) => {
        this.menuExpanded = show;
      });
    }
  }
  componentDidLoad() {
    this.attachSiemensLogoIfLoaded();
  }
  disconnectedCallback() {
    var _a, _b;
    (_a = this.menuDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
    (_b = this.modeDisposable) === null || _b === void 0 ? void 0 : _b.dispose();
  }
  async attachSiemensLogoIfLoaded() {
    await window.customElements.whenDefined('ix-siemens-logo');
    const logoElement = document.createElement('ix-siemens-logo');
    if (!this.host.querySelector('[slot="logo"]')) {
      this.host.shadowRoot.querySelector('.logo').appendChild(logoElement);
    }
  }
  async onMenuClick() {
    menuController.toggle();
  }
  render() {
    return (h(Host, { class: { [`mode-${this.mode}`]: true } }, this.mode === 'mobile' ? (h("ix-burger-menu", { onClick: () => this.onMenuClick(), expanded: this.menuExpanded })) : null, h("div", { class: "logo" }, h("slot", { name: "logo" })), h("div", { class: "name" }, this.name), h("slot", null)));
  }
  static get is() { return "ix-application-header"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["application-header.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["application-header.css"]
    };
  }
  static get properties() {
    return {
      "name": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Application name"
        },
        "attribute": "name",
        "reflect": false
      }
    };
  }
  static get states() {
    return {
      "mode": {},
      "menuExpanded": {}
    };
  }
  static get elementRef() { return "host"; }
}
//# sourceMappingURL=application-header.js.map
