/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
import { screenMode } from '../utils/screen/service';
export class BasicNavigation {
  constructor() {
    this.applicationName = undefined;
    this.hideHeader = false;
    this.mode = 'desktop';
  }
  get menu() {
    return this.hostElement.querySelector('ix-menu');
  }
  componentWillLoad() {
    if (this.hideHeader === false) {
      this.modeDisposable = screenMode.onChange.on((mode) => (this.mode = mode));
      this.mode = screenMode.mode;
    }
  }
  componentDidRender() {
    if (this.menu) {
      this.appendMenu();
      this.adjustMenuHeight();
      this.menu.applicationName = this.applicationName;
    }
  }
  disconnectedCallback() {
    var _a;
    (_a = this.modeDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
  }
  appendMenu() {
    this.hostElement.querySelector('#menu-placeholder').appendChild(this.menu);
  }
  adjustMenuHeight() {
    if (!this.hideHeader) {
      this.menu.style.height = 'calc(100% - 2.75rem)';
    }
  }
  render() {
    return (h(Host, { "data-role": "", class: {
        'hide-header': this.hideHeader,
        [`mode-${this.mode}`]: true,
      } }, !this.hideHeader ? (h("ix-application-header", { name: this.applicationName }, h("slot", { name: "logo" }))) : null, h("div", { id: "menu-placeholder" }), h("div", { class: "content", onClick: () => this.menu.toggleMenu(false) }, h("slot", null))));
  }
  static get is() { return "ix-basic-navigation"; }
  static get encapsulation() { return "scoped"; }
  static get originalStyleUrls() {
    return {
      "$": ["basic-navigation.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["basic-navigation.css"]
    };
  }
  static get properties() {
    return {
      "applicationName": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Application name"
        },
        "attribute": "application-name",
        "reflect": false
      },
      "hideHeader": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Hide application header. Will disable responsive feature of basic navigation."
        },
        "attribute": "hide-header",
        "reflect": false,
        "defaultValue": "false"
      }
    };
  }
  static get states() {
    return {
      "mode": {}
    };
  }
  static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=basic-navigation.js.map
