/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host, } from '@stencil/core';
import anime from 'animejs';
import { a11yBoolean } from '../utils/a11y';
let sequentialInstanceId = 0;
export class Blind {
  constructor() {
    this.id = ++sequentialInstanceId;
    this.collapsed = false;
    this.label = undefined;
    this.icon = undefined;
  }
  onHeaderClick(e) {
    if (e.target.closest('.header-actions')) {
      return;
    }
    e.preventDefault();
    e.stopImmediatePropagation();
    this.collapsed = !this.collapsed;
    this.collapsedChange.emit(this.collapsed);
  }
  componentDidLoad() {
    this.animateCollapse(this.collapsed);
  }
  get content() {
    return this.hostElement.shadowRoot.querySelector('.blind-content');
  }
  animation(isCollapsed) {
    this.animateCollapse(isCollapsed);
  }
  animateCollapse(isCollapsed) {
    if (isCollapsed) {
      this.rotateChevronRight();
    }
    else {
      this.rotateChevronDown();
    }
  }
  rotateChevronDown() {
    anime({
      targets: this.chevronRef,
      duration: 150,
      easing: 'easeInOutSine',
      rotateZ: 90,
    });
    anime({
      targets: this.content,
      duration: 150,
      easing: 'easeInOutSine',
      opacity: 1,
    });
  }
  rotateChevronRight() {
    anime({
      targets: this.chevronRef,
      duration: 150,
      easing: 'easeInOutSine',
      rotateZ: 0,
    });
    anime({
      targets: this.content,
      duration: 150,
      easing: 'easeInOutSine',
      opacity: 0,
    });
  }
  render() {
    return (h(Host, null, h("button", { class: {
        'blind-header': true,
        closed: this.collapsed,
      }, type: "button", "aria-labelledby": `ix-blind-header-title-${this.id}`, "aria-controls": `ix-blind-content-section-${this.id}`, "aria-expanded": a11yBoolean(!this.collapsed), onClick: (e) => this.onHeaderClick(e) }, h("ix-icon", { class: 'collapse-icon', name: "chevron-right-small", ref: (ref) => (this.chevronRef = ref) }), h("div", { class: "blind-header-title", id: `ix-blind-header-title-${this.id}` }, this.label !== undefined ? (h("span", { class: "blind-header-title-basic" }, this.icon !== undefined ? (h("ix-icon", { name: this.icon })) : (''), h("span", { class: "blind-header-title-default" }, this.label), h("span", { class: "header-actions", onClick: (e) => e.stopImmediatePropagation() }, h("slot", { name: "header-actions" })))) : (h("slot", { name: "custom-header" })))), h("section", { id: `ix-blind-content-section-${this.id}`, "aria-labelledby": `ix-blind-header-title-${this.id}` }, h("div", { class: {
        'blind-content': true,
        hide: this.collapsed,
      } }, h("slot", null)))));
  }
  static get is() { return "ix-blind"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["blind.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["blind.css"]
    };
  }
  static get properties() {
    return {
      "collapsed": {
        "type": "boolean",
        "mutable": true,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Collapsed state"
        },
        "attribute": "collapsed",
        "reflect": true,
        "defaultValue": "false"
      },
      "label": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Label of blind"
        },
        "attribute": "label",
        "reflect": false
      },
      "icon": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "since",
              "text": "1.5.0"
            }],
          "text": "Optional icon to be displayed next to the header label"
        },
        "attribute": "icon",
        "reflect": false
      }
    };
  }
  static get events() {
    return [{
        "method": "collapsedChange",
        "name": "collapsedChange",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "Collapsed state changed"
        },
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        }
      }];
  }
  static get elementRef() { return "hostElement"; }
  static get watchers() {
    return [{
        "propName": "collapsed",
        "methodName": "animation"
      }];
  }
}
//# sourceMappingURL=blind.js.map
