import { h, Host, } from '@stencil/core';
let accordionControlId = 0;
const getAriaControlsId = (prefix = 'expand-content') => {
  return [prefix, accordionControlId++].join('-');
};
/**
 * @since 1.6.0
 */
export class CardAccordion {
  constructor() {
    this.expandContent = false;
  }
  get expandedContent() {
    return this.hostElement.shadowRoot.querySelector('.expand-content');
  }
  onExpandActionClick(event) {
    event.preventDefault();
    event.stopPropagation();
    this.expandContent = !this.expandContent;
    this.accordionExpand.emit({
      expand: this.expandContent,
      nativeEvent: event,
    });
    if (this.expandContent) {
      this.scrollExpandedContentIntoView();
    }
  }
  scrollExpandedContentIntoView() {
    setTimeout(() => {
      const rect = this.expandedContent.getBoundingClientRect();
      if (rect.bottom > window.innerHeight) {
        this.hostElement.shadowRoot
          .querySelector('.expand-content')
          .scrollIntoView(false);
      }
    }, 150);
  }
  render() {
    return (h(Host, { slot: "card-accordion", class: {
        show: this.expandContent,
      } }, h("button", { tabIndex: 0, class: { 'expand-action': true, show: this.expandContent }, onClick: (event) => this.onExpandActionClick(event), role: "button", type: "button", "aria-expanded": this.expandContent, "aria-controls": getAriaControlsId() }, h("ix-icon", { name: "chevron-right-small", class: {
        'expand-icon': true,
        show: this.expandContent,
      } })), h("div", { class: {
        'expand-content': true,
        show: this.expandContent,
      } }, h("div", { class: 'expand-content-body' }, h("slot", null)), h("div", { class: 'expand-content-footer' }))));
  }
  static get is() { return "ix-card-accordion"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["card-accordion.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["card-accordion.css"]
    };
  }
  static get states() {
    return {
      "expandContent": {}
    };
  }
  static get events() {
    return [{
        "method": "accordionExpand",
        "name": "accordionExpand",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [{
              "name": "internal",
              "text": undefined
            }],
          "text": ""
        },
        "complexType": {
          "original": "CardAccordionExpandChangeEvent",
          "resolved": "{ expand: boolean; nativeEvent: Event; }",
          "references": {
            "CardAccordionExpandChangeEvent": {
              "location": "local",
              "path": "/__w/ix/ix/packages/core/src/components/card-accordion/card-accordion.tsx"
            }
          }
        }
      }];
  }
  static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=card-accordion.js.map
