import { h, Host } from '@stencil/core';
/**
 * @slot title-actions - Place additional actions inside title
 *
 * @since 1.6.0
 */
export class CardHeader {
  render() {
    return (h(Host, null, h("slot", null), h("div", { class: "title-actions" }, h("slot", { name: "title-actions" }))));
  }
  static get is() { return "ix-card-title"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["card-title.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["card-title.css"]
    };
  }
}
//# sourceMappingURL=card-title.js.map
