import { h, Host } from '@stencil/core';
/**
 * @since 1.6.0
 */
export class Card {
  constructor() {
    this.variant = 'insight';
  }
  render() {
    return (h(Host, { class: `card-${this.variant}` }, h("div", { class: "card-content" }, h("slot", null)), h("div", { class: "card-footer" }, h("slot", { name: "card-accordion" }))));
  }
  static get is() { return "ix-card"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["card.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["card.css"]
    };
  }
  static get properties() {
    return {
      "variant": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "CardVariant",
          "resolved": "\"alarm\" | \"critical\" | \"info\" | \"insight\" | \"neutral\" | \"notification\" | \"success\" | \"warning\"",
          "references": {
            "CardVariant": {
              "location": "local",
              "path": "/__w/ix/ix/packages/core/src/components/card/card.tsx"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card variant"
        },
        "attribute": "variant",
        "reflect": false,
        "defaultValue": "'insight'"
      }
    };
  }
  static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=card.js.map
