/*
 * SPDX-FileCopyrightText: 2022 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
/**
 * @internal
 */
export class IxIndexButton {
  constructor() {
    this.variant = 'Primary';
    this.selected = undefined;
  }
  render() {
    return (h(Host, null, h("button", { class: {
        btn: true,
        'btn-invisible-primary': this.variant === 'Primary',
        'btn-invisible-secondary': this.variant === 'Secondary',
        selected: this.selected,
      } }, h("slot", null))));
  }
  static get is() { return "ix-index-button"; }
  static get encapsulation() { return "scoped"; }
  static get originalStyleUrls() {
    return {
      "$": ["index-button.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["index-button.css"]
    };
  }
  static get properties() {
    return {
      "variant": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "IndexButtonVariant",
          "resolved": "\"Primary\" | \"Secondary\"",
          "references": {
            "IndexButtonVariant": {
              "location": "local",
              "path": "/__w/ix/ix/packages/core/src/components/index-button/index-button.tsx"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Button variant"
        },
        "attribute": "variant",
        "reflect": false,
        "defaultValue": "'Primary'"
      },
      "selected": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Selection state"
        },
        "attribute": "selected",
        "reflect": false
      }
    };
  }
}
//# sourceMappingURL=index-button.js.map
