/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
import { createMutationObserver } from '../utils/mutation-observer';
export class MenuItem {
  constructor() {
    this.home = false;
    this.bottom = false;
    this.tabIcon = 'document';
    this.notifications = undefined;
    this.active = undefined;
    this.disabled = undefined;
    this.title = undefined;
  }
  componentWillRender() {
    this.title = this.hostElement.innerText;
  }
  connectedCallback() {
    this.observer = createMutationObserver(() => {
      this.title = this.hostElement.innerText;
    });
    this.observer.observe(this.hostElement, {
      subtree: true,
      childList: true,
      characterData: true,
    });
  }
  disconnectedCallback() {
    if (this.observer) {
      this.observer.disconnect();
    }
  }
  render() {
    return (h(Host, { class: {
        disabled: this.disabled,
        'home-tab': this.home,
        'bottom-tab': this.bottom,
        active: this.active,
      } }, h("li", { class: "tab", title: this.title }, h("ix-icon", { name: this.tabIcon }), h("div", { class: "notification" }, this.notifications ? (h("div", { class: "pill" }, this.notifications)) : null), h("span", { class: "tab-text text-default" }, h("slot", null)))));
  }
  static get is() { return "ix-menu-item"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["menu-item.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["menu-item.css"]
    };
  }
  static get properties() {
    return {
      "home": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Move the Tab to a top position."
        },
        "attribute": "home",
        "reflect": false,
        "defaultValue": "false"
      },
      "bottom": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "deprecated",
              "text": "Will be removed in 2.0.0. Replaced by slot based implementation"
            }],
          "text": "Caution: this is no longer working. Please use slot=\"bottom\" instead.\n\nPlace tab on bottom"
        },
        "attribute": "bottom",
        "reflect": false,
        "defaultValue": "false"
      },
      "tabIcon": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Icon name from @siemens/ix-icons"
        },
        "attribute": "tab-icon",
        "reflect": false,
        "defaultValue": "'document'"
      },
      "notifications": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Show notification count on tab"
        },
        "attribute": "notifications",
        "reflect": false
      },
      "active": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "State to display active"
        },
        "attribute": "active",
        "reflect": false
      },
      "disabled": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Disable tab and remove event handlers"
        },
        "attribute": "disabled",
        "reflect": false
      }
    };
  }
  static get states() {
    return {
      "title": {}
    };
  }
  static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=menu-item.js.map
