/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from '@stencil/core';
/**
 * @since 1.6.0
 */
export class PushCard {
  constructor() {
    this.icon = undefined;
    this.notification = undefined;
    this.heading = undefined;
    this.subheading = undefined;
    this.variant = 'insight';
  }
  render() {
    var _a;
    return (h(Host, null, h("ix-card", { variant: this.variant }, h("ix-card-title", null, this.icon ? (h("ix-icon", { class: 'icon', name: this.icon, size: "32" })) : null, h("span", { class: 'notification' }, (_a = this.notification) !== null && _a !== void 0 ? _a : 0), h("slot", { name: "title-action" })), h("ix-card-content", null, h("ix-typography", { variant: "default-title-single" }, this.heading), h("ix-typography", null, this.subheading)), h("ix-card-accordion", null, h("slot", null)))));
  }
  static get is() { return "ix-push-card"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["push-card.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["push-card.css"]
    };
  }
  static get properties() {
    return {
      "icon": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string | undefined",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card icon"
        },
        "attribute": "icon",
        "reflect": false,
        "defaultValue": "undefined"
      },
      "notification": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card KPI value"
        },
        "attribute": "notification",
        "reflect": false
      },
      "heading": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card heading"
        },
        "attribute": "heading",
        "reflect": false
      },
      "subheading": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "string",
          "resolved": "string",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card subheading"
        },
        "attribute": "subheading",
        "reflect": false
      },
      "variant": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "PushCardVariant",
          "resolved": "\"alarm\" | \"critical\" | \"info\" | \"insight\" | \"neutral\" | \"notification\" | \"success\" | \"warning\"",
          "references": {
            "PushCardVariant": {
              "location": "local",
              "path": "/__w/ix/ix/packages/core/src/components/push-card/push-card.tsx"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Card variant"
        },
        "attribute": "variant",
        "reflect": false,
        "defaultValue": "'insight'"
      }
    };
  }
}
//# sourceMappingURL=push-card.js.map
