/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h } from '@stencil/core';
import { VariantsMapping } from './type-mapping';
/**
 * @internal
 */
export class IxTypography {
  constructor() {
    this.variant = 'default';
    this.color = undefined;
  }
  render() {
    const typographyClass = {
      [VariantsMapping[this.variant]]: true,
    };
    const fontColor = this.color !== undefined
      ? `var(--theme-color-${this.color}-text)`
      : 'inherit';
    return (h("div", { class: typographyClass, style: {
        color: fontColor,
      } }, h("slot", null)));
  }
  static get is() { return "ix-typography"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() {
    return {
      "$": ["typography.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["typography.css"]
    };
  }
  static get properties() {
    return {
      "variant": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "TypographyVariants",
          "resolved": "\"caption\" | \"caption-single\" | \"default\" | \"default-single\" | \"default-title\" | \"default-title-single\" | \"display-large\" | \"h2\" | \"large\" | \"large-single\" | \"large-title\" | \"large-title-single\" | \"small\" | \"x-small\"",
          "references": {
            "TypographyVariants": {
              "location": "local",
              "path": "/__w/ix/ix/packages/core/src/components/typography/typography.tsx"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Font variant based on theme variables"
        },
        "attribute": "variant",
        "reflect": false,
        "defaultValue": "'default'"
      },
      "color": {
        "type": "string",
        "mutable": false,
        "complexType": {
          "original": "TypographyColors",
          "resolved": "\"alarm\" | \"contrast\" | \"inv-contrast\" | \"inv-soft\" | \"inv-std\" | \"inv-weak\" | \"soft\" | \"std\" | \"weak\"",
          "references": {
            "TypographyColors": {
              "location": "local",
              "path": "/__w/ix/ix/packages/core/src/components/typography/typography.tsx"
            }
          }
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Text color based on theme variables"
        },
        "attribute": "color",
        "reflect": false
      }
    };
  }
}
//# sourceMappingURL=typography.js.map
