/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { TypedEvent } from '../typed-event';
class MenuService {
  constructor() {
    this.menuElement = null;
    this.menuExpandChange = new TypedEvent();
  }
  register(menuElement) {
    if (this.menuElement) {
      console.warn('Menu already defined');
      return;
    }
    this.menuElement = menuElement;
    this.menuElement.addEventListener('expandChange', (event) => {
      this.menuExpandChange.emit(event.detail);
    });
  }
  async open() {
    if (this.menuElement) {
      this.menuElement.toggleMenu(true);
      return true;
    }
    return false;
  }
  async close() {
    if (this.menuElement) {
      this.menuElement.toggleMenu(false);
      return true;
    }
    return false;
  }
  async toggle() {
    if (this.menuElement) {
      this.menuElement.toggleMenu();
      return true;
    }
    return false;
  }
  get nativeElement() {
    return this.menuElement;
  }
  get expandChange() {
    return this.menuExpandChange;
  }
}
export const menuController = new MenuService();
//# sourceMappingURL=menu-service.js.map
