/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host, } from '@stencil/core';
import { createMutationObserver } from '../utils/mutation-observer';
export class WorkflowSteps {
  constructor() {
    this.vertical = false;
    this.linear = false;
    this.clickable = false;
    this.selectedIndex = 0;
  }
  getSteps() {
    return Array.from(this.hostElement.querySelectorAll('ix-workflow-step'));
  }
  get stepsContent() {
    return this.hostElement.querySelector('.steps');
  }
  updateSteps() {
    let steps = this.getSteps();
    steps.forEach((element, index) => {
      element.vertical = this.vertical;
      element.clickable = this.clickable;
      element.selected = this.selectedIndex === index;
      if (steps.length === 1) {
        element.position = 'single';
        return;
      }
      if (index === 0) {
        element.position = 'first';
      }
      else if (index === steps.length - 1) {
        element.position = 'last';
      }
      else {
        element.position = 'undefined';
      }
    });
  }
  componentDidLoad() {
    this.stepsContent.addEventListener('selectedChanged', (event) => {
      const steps = this.getSteps();
      steps.forEach((element) => {
        if (element !== event.target) {
          element.selected = false;
        }
      });
    });
    const slotDiv = this.hostElement.querySelector('.steps');
    this.observer = createMutationObserver((mutations) => {
      for (let mutation of mutations) {
        if (mutation.type === 'childList') {
          this.updateSteps();
        }
      }
    });
    this.observer.observe(slotDiv, { childList: true });
  }
  disconnectedCallback() {
    if (this.observer) {
      this.observer.disconnect();
    }
  }
  componentDidRender() {
    this.updateSteps();
  }
  render() {
    return (h(Host, null, h("div", { class: { steps: true, vertical: this.vertical } }, h("slot", null))));
  }
  static get is() { return "ix-workflow-steps"; }
  static get encapsulation() { return "scoped"; }
  static get originalStyleUrls() {
    return {
      "$": ["workflow-steps.scss"]
    };
  }
  static get styleUrls() {
    return {
      "$": ["workflow-steps.css"]
    };
  }
  static get properties() {
    return {
      "vertical": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Select orientation"
        },
        "attribute": "vertical",
        "reflect": false,
        "defaultValue": "false"
      },
      "linear": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [{
              "name": "deprecated",
              "text": "Has no effect on component. Will get removed in 2.0.0"
            }],
          "text": "Select linear mode"
        },
        "attribute": "linear",
        "reflect": false,
        "defaultValue": "false"
      },
      "clickable": {
        "type": "boolean",
        "mutable": false,
        "complexType": {
          "original": "boolean",
          "resolved": "boolean",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Activate navigation click"
        },
        "attribute": "clickable",
        "reflect": false,
        "defaultValue": "false"
      },
      "selectedIndex": {
        "type": "number",
        "mutable": false,
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        },
        "required": false,
        "optional": false,
        "docs": {
          "tags": [],
          "text": "Activate navigation click"
        },
        "attribute": "selected-index",
        "reflect": false,
        "defaultValue": "0"
      }
    };
  }
  static get events() {
    return [{
        "method": "stepSelected",
        "name": "stepSelected",
        "bubbles": true,
        "cancelable": true,
        "composed": true,
        "docs": {
          "tags": [],
          "text": "On step selected event"
        },
        "complexType": {
          "original": "number",
          "resolved": "number",
          "references": {}
        }
      }];
  }
  static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=workflow-steps.js.map
