/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { test as base } from '@playwright/test';
async function extendPageFixture(page, testInfo) {
  const originalGoto = page.goto.bind(page);
  const theme = testInfo.project.metadata.theme;
  testInfo.annotations.push({
    type: theme,
  });
  page.goto = async (url, options) => {
    const response = await originalGoto(`http://127.0.0.1:8080/src/tests/${url}?theme=${theme}`, options);
    await page.waitForTimeout(1000);
    return response;
  };
  return page;
}
export const regressionTest = base.extend({
  page: async ({ page }, use, testInfo) => {
    page = await extendPageFixture(page, testInfo);
    await use(page);
  },
});
export const test = base.extend({
  createElement: async ({ page }, use) => {
    use((selector, appendTo) => page.evaluateHandle(async ({ selector, appendTo }) => {
      const elm = document.createElement(selector);
      if (appendTo) {
        appendTo.appendChild(elm);
      }
      return elm;
    }, {
      selector,
      appendTo,
    }));
  },
  mount: async ({ page }, use, testInfo) => {
    const theme = testInfo.project.metadata.theme;
    testInfo.annotations.push({
      type: theme,
    });
    await page.goto(`http://127.0.0.1:8080/src/tests/utils/ct/index.html?theme=${theme}`);
    use((selector) => {
      return page.evaluateHandle(async ({ componentSelector }) => {
        await window.customElements.whenDefined('ix-button');
        const mount = document.querySelector('#mount');
        mount.innerHTML = componentSelector;
        return mount.children.item(0);
      }, { componentSelector: selector });
    });
  },
});
//# sourceMappingURL=page.js.map
