import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { h as hostContext, i as isBasicNavigationLayout, s as screenMode, m as menuController } from './service.js';
import { d as defineCustomElement$1 } from './burger-menu.js';

const applicationHeaderCss = ":host{display:flex;align-items:center;position:relative;width:100%;height:2.75rem;padding-left:1rem;color:var(--theme-app-header--color);background-color:var(--theme-app-header--background);border-bottom:var(--theme-app-header--border-width) solid var(--theme-app-header--border-color)}:host .name{margin-left:2.5rem;margin-right:2.5rem;color:var(--theme-app-header--color)}:host .logo{display:inline-flex;align-items:center;position:relative;height:32px;overflow:hidden;line-height:0rem;color:var(--theme-app-header-logo--color)}:host(.mode-mobile){padding-left:0.5rem}:host(.mode-mobile) .logo{margin-left:0.5rem}";

const ApplicationHeader = /*@__PURE__*/ proxyCustomElement(class ApplicationHeader extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.__attachShadow();
    this.name = undefined;
    this.mode = 'desktop';
    this.menuExpanded = false;
  }
  componentWillLoad() {
    const layout = hostContext('ix-basic-navigation', this.host);
    if (isBasicNavigationLayout(layout)) {
      this.modeDisposable = screenMode.onChange.on((mode) => (this.mode = mode));
      this.mode = screenMode.mode;
      this.menuDisposable = menuController.expandChange.on((show) => {
        this.menuExpanded = show;
      });
    }
  }
  componentDidLoad() {
    this.attachSiemensLogoIfLoaded();
  }
  disconnectedCallback() {
    var _a, _b;
    (_a = this.menuDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
    (_b = this.modeDisposable) === null || _b === void 0 ? void 0 : _b.dispose();
  }
  async attachSiemensLogoIfLoaded() {
    await window.customElements.whenDefined('ix-siemens-logo');
    const logoElement = document.createElement('ix-siemens-logo');
    if (!this.host.querySelector('[slot="logo"]')) {
      this.host.shadowRoot.querySelector('.logo').appendChild(logoElement);
    }
  }
  async onMenuClick() {
    menuController.toggle();
  }
  render() {
    return (h(Host, { class: { [`mode-${this.mode}`]: true } }, this.mode === 'mobile' ? (h("ix-burger-menu", { onClick: () => this.onMenuClick(), expanded: this.menuExpanded })) : null, h("div", { class: "logo" }, h("slot", { name: "logo" })), h("div", { class: "name" }, this.name), h("slot", null)));
  }
  get host() { return this; }
  static get style() { return applicationHeaderCss; }
}, [1, "ix-application-header", {
    "name": [1],
    "mode": [32],
    "menuExpanded": [32]
  }]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-application-header", "ix-burger-menu"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-application-header":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, ApplicationHeader);
      }
      break;
    case "ix-burger-menu":
      if (!customElements.get(tagName)) {
        defineCustomElement$1();
      }
      break;
  } });
}

export { ApplicationHeader as A, defineCustomElement as d };

//# sourceMappingURL=application-header.js.map