import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const cardContentCss = ":host{display:flex;position:relative;flex-direction:column;align-items:flex-start;gap:0.5rem;height:100%}:host *,:host *::after,:host *::before{box-sizing:border-box}";

const CardContent = /*@__PURE__*/ proxyCustomElement(class CardContent extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.__attachShadow();
  }
  render() {
    return (h(Host, null, h("slot", null)));
  }
  static get style() { return cardContentCss; }
}, [1, "ix-card-content"]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-card-content"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-card-content":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, CardContent);
      }
      break;
  } });
}

export { CardContent as C, defineCustomElement as d };

//# sourceMappingURL=card-content.js.map