import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const cardTitleCss = ":host{display:flex;position:relative;flex-direction:row;align-items:center;padding:0px;margin-bottom:0.5rem;gap:1rem;width:100%}:host .title-actions{display:flex;position:relative;flex-direction:row;gap:0.25rem;margin-left:auto;margin-right:0px}";

const CardHeader = /*@__PURE__*/ proxyCustomElement(class CardHeader extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.__attachShadow();
  }
  render() {
    return (h(Host, null, h("slot", null), h("div", { class: "title-actions" }, h("slot", { name: "title-actions" }))));
  }
  static get style() { return cardTitleCss; }
}, [1, "ix-card-title"]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-card-title"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-card-title":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, CardHeader);
      }
      break;
  } });
}

export { CardHeader as C, defineCustomElement as d };

//# sourceMappingURL=card-title.js.map