import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const cardCss = ":host{display:flex;position:relative;flex-direction:column;align-items:flex-start;align-self:flex-start;overflow:hidden;width:20rem;border:1px solid var(--ix-card-border-color, var(--theme-color-soft-bdr));border-radius:var(--theme-default-border-radius)}:host *,:host *::after,:host *::before{box-sizing:border-box}:host .card-content{display:block;position:relative;flex-shrink:0;flex-grow:1;width:100%;padding:1rem 1rem;height:calc(100% - 2rem);background-color:var(--ix-card-background, transparent);border-top-left-radius:var(--theme-default-border-radius);border-top-right-radius:var(--theme-default-border-radius)}:host .card-footer{display:flex;position:relative;width:100%}:host(.card-insight){--ix-card-background:transparent;--ix-card-border-color:var(--theme-color-soft-bdr)}:host(.card-notification){--ix-card-background:var(--theme-color-component-1)}:host(.card-alarm){--ix-card-background:var(--theme-color-alarm);color:var(--theme-color-alarm--contrast)}:host(.card-critical){--ix-card-background:var(--theme-color-critical);color:var(--theme-color-critical--contrast)}:host(.card-warning){--ix-card-background:var(--theme-color-warning);color:var(--theme-color-warning--contrast)}:host(.card-success){--ix-card-background:var(--theme-color-success);color:var(--theme-color-success--contrast)}:host(.card-info){--ix-card-background:var(--theme-color-info);color:var(--theme-color-info--contrast)}:host(.card-neutral){--ix-card-background:var(--theme-color-neutral);color:var(--theme-color-neutral--contrast)}:host(:not(.card-insight)){--ix-card-border-color:transparent}";

const Card = /*@__PURE__*/ proxyCustomElement(class Card extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.__attachShadow();
    this.variant = 'insight';
  }
  render() {
    return (h(Host, { class: `card-${this.variant}` }, h("div", { class: "card-content" }, h("slot", null)), h("div", { class: "card-footer" }, h("slot", { name: "card-accordion" }))));
  }
  get hostElement() { return this; }
  static get style() { return cardCss; }
}, [1, "ix-card", {
    "variant": [1]
  }]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-card"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-card":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, Card);
      }
      break;
  } });
}

export { Card as C, defineCustomElement as d };

//# sourceMappingURL=card.js.map