import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { d as defineCustomElement$1 } from './icon.js';

const dropdownItemCss = ".sc-ix-dropdown-item-h{display:block}.icon-only.sc-ix-dropdown-item-h{min-width:0}.icon-only.sc-ix-dropdown-item-h .dropdown-item.sc-ix-dropdown-item>.glyph.sc-ix-dropdown-item{-webkit-margin-end:0;margin-inline-end:0}.icon-only.sc-ix-dropdown-item-h .dropdown-item.sc-ix-dropdown-item{padding:0.25rem 0.5rem}.icon-only.sc-ix-dropdown-item-h .dropdown-item.sc-ix-dropdown-item:not(.disabled):not(:disabled):focus-visible{border-color:#199fff}.sc-ix-dropdown-item-h .sc-ix-dropdown-item:focus{background-color:transparent;color:var(--theme-menu-item--color)}.sc-ix-dropdown-item-h .checkmark.sc-ix-dropdown-item{position:absolute;left:0.5rem}.checked.sc-ix-dropdown-item-h{background-color:var(--theme-select-list-item--background--selected)}.sc-ix-dropdown-item-h .label.sc-ix-dropdown-item{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.disabled.sc-ix-dropdown-item-h{pointer-events:none}.sc-ix-dropdown-item-s>ix-icon{-webkit-margin-start:auto;margin-inline-start:auto}";

const DropdownItem = /*@__PURE__*/ proxyCustomElement(class DropdownItem extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.itemClick = createEvent(this, "itemClick", 7);
    this.label = undefined;
    this.icon = undefined;
    this.hover = false;
    this.disabled = false;
    this.checked = false;
  }
  /**
   * Internal usage only
   */
  async emitItemClick() {
    this.itemClick.emit(this.hostElement);
  }
  render() {
    return (h(Host, { class: {
        checked: this.checked,
        'icon-text': this.label !== undefined && this.icon !== undefined,
        'icon-only': this.label === undefined && this.icon !== undefined,
        disabled: this.disabled,
      } }, h("button", { type: "button", class: {
        'dropdown-item': true,
        hover: this.hover,
        disabled: this.disabled,
      }, onClick: () => this.emitItemClick(), tabindex: 0 }, this.checked ? (h("ix-icon", { class: "checkmark", name: "single-check", size: "16" })) : null, this.icon ? (h("span", { class: {
        glyph: true,
        [`glyph-${this.icon}`]: true,
        disabled: this.disabled,
      } })) : null, this.label ? h("span", { class: "label" }, this.label) : null, h("slot", null))));
  }
  get hostElement() { return this; }
  static get style() { return dropdownItemCss; }
}, [6, "ix-dropdown-item", {
    "label": [1],
    "icon": [1],
    "hover": [4],
    "disabled": [4],
    "checked": [4],
    "emitItemClick": [64]
  }]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-dropdown-item", "ix-icon"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-dropdown-item":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, DropdownItem);
      }
      break;
    case "ix-icon":
      if (!customElements.get(tagName)) {
        defineCustomElement$1();
      }
      break;
  } });
}

export { DropdownItem as D, defineCustomElement as d };

//# sourceMappingURL=dropdown-item.js.map