import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const indexButtonCss = ".sc-ix-index-button-h{max-height:2rem}.sc-ix-index-button-h .btn.sc-ix-index-button{min-width:2rem;height:2rem}.sc-ix-index-button-h .btn.selected.sc-ix-index-button{background-color:var(--theme-btn-invisible-secondary--background--selected);color:var(--theme-btn-invisible-secondary--color--selected)}";

const IxIndexButton = /*@__PURE__*/ proxyCustomElement(class IxIndexButton extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.variant = 'Primary';
    this.selected = undefined;
  }
  render() {
    return (h(Host, null, h("button", { class: {
        btn: true,
        'btn-invisible-primary': this.variant === 'Primary',
        'btn-invisible-secondary': this.variant === 'Secondary',
        selected: this.selected,
      } }, h("slot", null))));
  }
  static get style() { return indexButtonCss; }
}, [6, "ix-index-button", {
    "variant": [1],
    "selected": [4]
  }]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-index-button"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-index-button":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, IxIndexButton);
      }
      break;
  } });
}

export { IxIndexButton as I, defineCustomElement as d };

//# sourceMappingURL=index-button.js.map