import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { s as screenMode } from './service.js';
import { d as defineCustomElement$3 } from './application-header.js';
import { d as defineCustomElement$2 } from './burger-menu.js';

const basicNavigationCss = ".sc-ix-basic-navigation-h{display:flex;position:relative;width:100%;height:100%;flex-direction:column}.sc-ix-basic-navigation-h ix-application-header.sc-ix-basic-navigation{z-index:calc(var(--theme-z-index-sticky) + 1)}.sc-ix-basic-navigation-h .content.sc-ix-basic-navigation{display:flex;height:calc(100% - 2.75rem);width:calc(100% - 3.25rem);position:relative;margin-left:3.25rem;overflow:auto}.hide-header.sc-ix-basic-navigation-h .content.sc-ix-basic-navigation{height:100%}.mode-mobile.sc-ix-basic-navigation-h .content.sc-ix-basic-navigation{margin-left:0px;width:100%}";

const BasicNavigation = /*@__PURE__*/ proxyCustomElement(class BasicNavigation extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.applicationName = undefined;
    this.hideHeader = false;
    this.mode = 'desktop';
  }
  get menu() {
    return this.hostElement.querySelector('ix-menu');
  }
  componentWillLoad() {
    if (this.hideHeader === false) {
      this.modeDisposable = screenMode.onChange.on((mode) => (this.mode = mode));
      this.mode = screenMode.mode;
    }
  }
  componentDidRender() {
    if (this.menu) {
      this.appendMenu();
      this.adjustMenuHeight();
      this.menu.applicationName = this.applicationName;
    }
  }
  disconnectedCallback() {
    var _a;
    (_a = this.modeDisposable) === null || _a === void 0 ? void 0 : _a.dispose();
  }
  appendMenu() {
    this.hostElement.querySelector('#menu-placeholder').appendChild(this.menu);
  }
  adjustMenuHeight() {
    if (!this.hideHeader) {
      this.menu.style.height = 'calc(100% - 2.75rem)';
    }
  }
  render() {
    return (h(Host, { "data-role": "", class: {
        'hide-header': this.hideHeader,
        [`mode-${this.mode}`]: true,
      } }, !this.hideHeader ? (h("ix-application-header", { name: this.applicationName }, h("slot", { name: "logo" }))) : null, h("div", { id: "menu-placeholder" }), h("div", { class: "content", onClick: () => this.menu.toggleMenu(false) }, h("slot", null))));
  }
  get hostElement() { return this; }
  static get style() { return basicNavigationCss; }
}, [6, "ix-basic-navigation", {
    "applicationName": [1, "application-name"],
    "hideHeader": [4, "hide-header"],
    "mode": [32]
  }]);
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-basic-navigation", "ix-application-header", "ix-burger-menu"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-basic-navigation":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, BasicNavigation);
      }
      break;
    case "ix-application-header":
      if (!customElements.get(tagName)) {
        defineCustomElement$3();
      }
      break;
    case "ix-burger-menu":
      if (!customElements.get(tagName)) {
        defineCustomElement$2();
      }
      break;
  } });
}

const IxBasicNavigation = BasicNavigation;
const defineCustomElement = defineCustomElement$1;

export { IxBasicNavigation, defineCustomElement };

//# sourceMappingURL=ix-basic-navigation.js.map