import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const dividerCss = ":host{display:block;position:relative;width:100%;border:0.0625rem solid var(--theme-color-x-weak-bdr);margin:0.25rem 0px}";

const Divider = /*@__PURE__*/ proxyCustomElement(class Divider extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.__attachShadow();
  }
  render() {
    return h(Host, null);
  }
  static get style() { return dividerCss; }
}, [1, "ix-divider"]);
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-divider"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-divider":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, Divider);
      }
      break;
  } });
}

const IxDivider = Divider;
const defineCustomElement = defineCustomElement$1;

export { IxDivider, defineCustomElement };

//# sourceMappingURL=ix-divider.js.map