import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { c as createMutationObserver } from './mutation-observer.js';

const workflowStepsCss = ".sc-ix-workflow-steps-h .steps.sc-ix-workflow-steps{display:flex}.sc-ix-workflow-steps-h .steps.vertical.sc-ix-workflow-steps{display:block}";

const WorkflowSteps = /*@__PURE__*/ proxyCustomElement(class WorkflowSteps extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.stepSelected = createEvent(this, "stepSelected", 7);
    this.vertical = false;
    this.linear = false;
    this.clickable = false;
    this.selectedIndex = 0;
  }
  getSteps() {
    return Array.from(this.hostElement.querySelectorAll('ix-workflow-step'));
  }
  get stepsContent() {
    return this.hostElement.querySelector('.steps');
  }
  updateSteps() {
    let steps = this.getSteps();
    steps.forEach((element, index) => {
      element.vertical = this.vertical;
      element.clickable = this.clickable;
      element.selected = this.selectedIndex === index;
      if (steps.length === 1) {
        element.position = 'single';
        return;
      }
      if (index === 0) {
        element.position = 'first';
      }
      else if (index === steps.length - 1) {
        element.position = 'last';
      }
      else {
        element.position = 'undefined';
      }
    });
  }
  componentDidLoad() {
    this.stepsContent.addEventListener('selectedChanged', (event) => {
      const steps = this.getSteps();
      steps.forEach((element) => {
        if (element !== event.target) {
          element.selected = false;
        }
      });
    });
    const slotDiv = this.hostElement.querySelector('.steps');
    this.observer = createMutationObserver((mutations) => {
      for (let mutation of mutations) {
        if (mutation.type === 'childList') {
          this.updateSteps();
        }
      }
    });
    this.observer.observe(slotDiv, { childList: true });
  }
  disconnectedCallback() {
    if (this.observer) {
      this.observer.disconnect();
    }
  }
  componentDidRender() {
    this.updateSteps();
  }
  render() {
    return (h(Host, null, h("div", { class: { steps: true, vertical: this.vertical } }, h("slot", null))));
  }
  get hostElement() { return this; }
  static get style() { return workflowStepsCss; }
}, [6, "ix-workflow-steps", {
    "vertical": [4],
    "linear": [4],
    "clickable": [4],
    "selectedIndex": [2, "selected-index"]
  }]);
function defineCustomElement$1() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-workflow-steps"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-workflow-steps":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, WorkflowSteps);
      }
      break;
  } });
}

const IxWorkflowSteps = WorkflowSteps;
const defineCustomElement = defineCustomElement$1;

export { IxWorkflowSteps, defineCustomElement };

//# sourceMappingURL=ix-workflow-steps.js.map