import { T as TypedEvent } from './typed-event.js';

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class MenuService {
  constructor() {
    this.menuElement = null;
    this.menuExpandChange = new TypedEvent();
  }
  register(menuElement) {
    if (this.menuElement) {
      console.warn('Menu already defined');
      return;
    }
    this.menuElement = menuElement;
    this.menuElement.addEventListener('expandChange', (event) => {
      this.menuExpandChange.emit(event.detail);
    });
  }
  async open() {
    if (this.menuElement) {
      this.menuElement.toggleMenu(true);
      return true;
    }
    return false;
  }
  async close() {
    if (this.menuElement) {
      this.menuElement.toggleMenu(false);
      return true;
    }
    return false;
  }
  async toggle() {
    if (this.menuElement) {
      this.menuElement.toggleMenu();
      return true;
    }
    return false;
  }
  get nativeElement() {
    return this.menuElement;
  }
  get expandChange() {
    return this.menuExpandChange;
  }
}
const menuController = new MenuService();

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function isBasicNavigationLayout(element) {
  return element && element.tagName === 'IX-BASIC-NAVIGATION';
}
const hostContext = (selector, element) => {
  return element.closest(selector);
};

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
const mobileMediaQuery = `only screen and (max-width: 767px)`;
const createMediaQueryListener = (query, callback) => {
  const fn = (event) => {
    callback(event);
  };
  const listener = window.matchMedia(query);
  listener.addEventListener('change', fn);
  return {
    matchMedia: listener,
    dispose: () => {
      listener.removeEventListener('change', fn);
    },
  };
};
const createModeListener = (modeChangeCallback) => {
  const listener = createMediaQueryListener(mobileMediaQuery, ({ matches }) => {
    if (matches) {
      modeChangeCallback('mobile');
      return;
    }
    modeChangeCallback('desktop');
  });
  modeChangeCallback(listener.matchMedia.matches ? 'mobile' : 'desktop');
  return {
    dispose: listener.dispose,
    matchMedia: listener.matchMedia,
  };
};

var __classPrivateFieldGet = (undefined && undefined.__classPrivateFieldGet) || function (receiver, state, kind, f) {
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
  return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (undefined && undefined.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
  if (kind === "m") throw new TypeError("Private method is not writable");
  if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
  if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
  return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _ScreenMode_modeChangeListener, _ScreenMode_mode;
class ScreenMode {
  constructor() {
    _ScreenMode_modeChangeListener.set(this, new TypedEvent());
    _ScreenMode_mode.set(this, 'desktop');
    createModeListener((mode) => {
      __classPrivateFieldGet(this, _ScreenMode_modeChangeListener, "f").emit(mode);
      __classPrivateFieldSet(this, _ScreenMode_mode, mode, "f");
    });
  }
  get mode() {
    return __classPrivateFieldGet(this, _ScreenMode_mode, "f");
  }
  get onChange() {
    return __classPrivateFieldGet(this, _ScreenMode_modeChangeListener, "f");
  }
}
_ScreenMode_modeChangeListener = new WeakMap(), _ScreenMode_mode = new WeakMap();
const screenMode = new ScreenMode();

export { hostContext as h, isBasicNavigationLayout as i, menuController as m, screenMode as s };

//# sourceMappingURL=service.js.map