import { proxyCustomElement, HTMLElement, createEvent, h, Host } from '@stencil/core/internal/client';
import { l as luxon } from './luxon.js';
import { d as defineCustomElement$4 } from './button.js';
import { d as defineCustomElement$3 } from './date-time-card.js';
import { d as defineCustomElement$2 } from './icon.js';
import { d as defineCustomElement$1 } from './icon-button.js';

const timePickerCss = ".header.sc-ix-time-picker{display:flex;align-items:center;justify-content:center}.title.sc-ix-time-picker{display:flex;align-items:center;font:var(--theme-text-default-title);min-height:2.5rem;color:var(--theme-datepicker-time-header--color)}.clock.sc-ix-time-picker{height:100%;display:flex;justify-content:center;align-items:center;padding:5rem 0}input.sc-ix-time-picker,.time-reference.sc-ix-time-picker{width:2.625rem;height:1.5rem;text-align:center;margin-top:0.5rem;margin-bottom:0.5rem}input.sc-ix-time-picker::-webkit-outer-spin-button,input.sc-ix-time-picker::-webkit-inner-spin-button,.time-reference.sc-ix-time-picker::-webkit-outer-spin-button,.time-reference.sc-ix-time-picker::-webkit-inner-spin-button{-webkit-appearance:none;margin:0 0.3125rem}input[type=number].sc-ix-time-picker,.time-reference[type=number].sc-ix-time-picker{-moz-appearance:textfield}.form-control[type=number].sc-ix-time-picker{text-align:center}.columns.sc-ix-time-picker{display:flex;flex-direction:column;align-items:center;justify-content:space-around}.column-seperator.sc-ix-time-picker{display:flex;align-items:center;margin:0 0.25rem}.button.sc-ix-time-picker{display:flex;justify-content:flex-end}.default-space.sc-ix-time-picker{margin-left:1rem}.text-align.sc-ix-time-picker{text-align:center}.hidden.sc-ix-time-picker{display:none}.time-reference.sc-ix-time-picker{margin:0.75rem 0}";

const TimePicker = /*@__PURE__*/ proxyCustomElement(class TimePicker extends HTMLElement {
  constructor() {
    super();
    this.__registerHost();
    this.done = createEvent(this, "done", 7);
    this.timeChange = createEvent(this, "timeChange", 7);
    this._time = luxon.DateTime.now();
    this.format = 'TT';
    this.corners = 'rounded';
    this.individual = true;
    this.showHour = false;
    this.showMinutes = false;
    this.showSeconds = false;
    this.time = luxon.DateTime.now().toFormat(this.format);
    this.showTimeReference = undefined;
    this.timeReference = luxon.DateTime.fromFormat(this.time, this.format).toFormat('a');
    this.textSelectTime = 'Done';
    this.hourInputRef = undefined;
    this.minuteInputRef = undefined;
    this.secondInputRef = undefined;
    this.referenceInputRef = undefined;
  }
  get hour() {
    return this._time.hour;
  }
  get minutes() {
    return this._time.minute;
  }
  get seconds() {
    return this._time.second;
  }
  setInputValue(inputElement, value, max) {
    if (value > max) {
      inputElement.value = max.toString();
    }
    else if (value < 0) {
      inputElement.value = '0';
    }
    else {
      inputElement.value = value.toString();
    }
    this.updateAndEmitTime();
  }
  updateAndEmitTime() {
    this._time = this._time.set({
      hour: Number(this.hourInputRef.value),
      minute: Number(this.minuteInputRef.value),
      second: Number(this.secondInputRef.value),
    });
    this.setHourAccordingToReference();
    this.emitTimeChange();
  }
  toggleInputValue(inputElement, currentValue, step, max) {
    if (step === 'up') {
      if (currentValue === max) {
        inputElement.value = '0';
      }
      else {
        inputElement.stepUp();
      }
    }
    else {
      if (currentValue === 0) {
        inputElement.value = max.toString();
      }
      else {
        inputElement.stepDown();
      }
    }
  }
  toggleHourInputWithRef(inputElement, currentValue, step) {
    if (step === 'up') {
      if (currentValue === this.getMaxHour()) {
        inputElement.value = '0';
      }
      else {
        inputElement.stepUp();
      }
    }
    else {
      if ((this.showTimeReference &&
        this.timeReference === 'PM' &&
        currentValue === 12) ||
        currentValue === 0) {
        inputElement.value = this.getMaxDisplayedHour().toString();
      }
      else {
        inputElement.stepDown();
      }
    }
  }
  updateInput(step, { hours = undefined, minutes = undefined, seconds = undefined }) {
    if (hours) {
      if (this.showTimeReference) {
        this.toggleHourInputWithRef(this.hourInputRef, this.hour, step);
      }
      else {
        this.toggleInputValue(this.hourInputRef, this.hour, step, 23);
      }
    }
    if (minutes) {
      this.toggleInputValue(this.minuteInputRef, this.minutes, step, 59);
    }
    if (seconds) {
      this.toggleInputValue(this.secondInputRef, this.seconds, step, 59);
    }
    this.updateAndEmitTime();
  }
  changeReference() {
    if (this.timeReference === 'AM') {
      this.timeReference = 'PM';
    }
    else {
      this.timeReference = 'AM';
    }
    this.setHourAccordingToReference();
    this.emitTimeChange();
  }
  setHourAccordingToReference() {
    if (!this.showTimeReference) {
      return;
    }
    let hour = Number(this.hourInputRef.value);
    if (this.timeReference === 'PM')
      hour += 12;
    this._time = this._time.set({ hour });
  }
  emitTimeChange() {
    const time = this._time.toFormat(this.format);
    this.timeChange.emit(time);
  }
  componentWillLoad() {
    this._time = luxon.DateTime.fromFormat(this.time, this.format);
    if (this.showTimeReference === undefined) {
      const matchedKeys = Object.keys(luxon.DateTime.fromFormatExplain(this.time, this.format).matches);
      this.showTimeReference = matchedKeys.includes('a');
    }
  }
  /**
   * Get current time
   */
  async getCurrentTime() {
    return this._time.toFormat(this.format);
  }
  getDisplayedHour() {
    if (this.showTimeReference && this.timeReference === 'PM') {
      return this._time.hour - 12;
    }
    return this._time.hour;
  }
  getMaxDisplayedHour() {
    if (this.showTimeReference) {
      return 11;
    }
    return 23;
  }
  getMaxHour() {
    if (this.showTimeReference && this.timeReference === 'AM') {
      return 11;
    }
    return 23;
  }
  render() {
    let hideHour = !this.showHour;
    let hideMinutes = !this.showMinutes;
    let hideSeconds = !this.showSeconds;
    const hideTimeReference = !this.showTimeReference;
    const hideIndividual = !this.individual;
    if (hideHour && hideMinutes && hideSeconds) {
      hideHour = false;
      hideMinutes = false;
      hideSeconds = false;
    }
    const hideHourSeperator = hideMinutes || hideHour;
    const hideMinutesSeperator = hideSeconds || hideMinutes;
    return (h(Host, null, h("ix-date-time-card", { individual: this.individual, corners: this.corners }, h("div", { class: "header", slot: "header" }, h("div", { class: "title" }, "Time")), h("div", { class: "clock" }, h("div", { class: { columns: true, hidden: hideHour } }, h("ix-icon-button", { size: "16", onClick: () => this.updateInput('up', { hours: true }), ghost: true, icon: "chevron-up", variant: "Primary", class: "arrows" }), h("input", { class: "form-control", name: "hours", type: "number", placeholder: "HH", min: "0", max: this.getMaxDisplayedHour(), value: this.getDisplayedHour(), ref: (ref) => (this.hourInputRef = ref), onChange: () => this.setInputValue(this.hourInputRef, Number(this.hourInputRef.value), this.getMaxDisplayedHour()) }), h("ix-icon-button", { size: "16", onClick: () => this.updateInput('down', { hours: true }), ghost: true, icon: "chevron-down", variant: "Primary", class: "arrows" })), h("div", { class: { 'column-seperator': true, hidden: hideHourSeperator } }, ":"), h("div", { class: { columns: true, hidden: hideMinutes } }, h("ix-icon-button", { size: "16", onClick: () => this.updateInput('up', { minutes: true }), ghost: true, icon: "chevron-up", variant: "Primary", class: "arrows" }), h("input", { class: "form-control", name: "minutes", type: "number", placeholder: "MM", min: "0", max: "59", value: this.minutes, ref: (ref) => (this.minuteInputRef = ref), onChange: () => this.setInputValue(this.minuteInputRef, Number(this.minuteInputRef.value), 59) }), h("ix-icon-button", { size: "16", onClick: () => this.updateInput('down', { minutes: true }), ghost: true, icon: "chevron-down", variant: "Primary", class: "arrows" })), h("div", { class: { 'column-seperator': true, hidden: hideMinutesSeperator } }, ":"), h("div", { class: { columns: true, hidden: hideSeconds } }, h("ix-icon-button", { size: "16", onClick: () => this.updateInput('up', { seconds: true }), ghost: true, icon: "chevron-up", variant: "Primary", class: "arrows" }), h("input", { class: "form-control", name: "seconds", type: "number", placeholder: "SS", min: "0", max: "59", value: this.seconds, ref: (ref) => (this.secondInputRef = ref), onChange: () => this.setInputValue(this.secondInputRef, Number(this.secondInputRef.value), 59) }), h("ix-icon-button", { size: "16", onClick: () => this.updateInput('down', { seconds: true }), ghost: true, icon: "chevron-down", variant: "Primary", class: "arrows" })), h("div", { class: {
        columns: true,
        'default-space': true,
        hidden: hideTimeReference,
      } }, h("ix-icon-button", { size: "16", onClick: () => this.changeReference(), ghost: true, icon: "chevron-up", variant: "Primary", class: "arrows" }), h("div", { class: "time-reference" }, this.timeReference), h("ix-icon-button", { size: "16", onClick: () => this.changeReference(), ghost: true, icon: "chevron-down", variant: "Primary", class: "arrows" }))), h("div", { class: { button: true, hidden: hideIndividual } }, h("ix-button", { onClick: () => this.done.emit(this._time.toFormat(this.format)) }, this.textSelectTime)))));
  }
  get hostElement() { return this; }
  static get style() { return timePickerCss; }
}, [2, "ix-time-picker", {
    "format": [1],
    "corners": [1],
    "individual": [4],
    "showHour": [4, "show-hour"],
    "showMinutes": [4, "show-minutes"],
    "showSeconds": [4, "show-seconds"],
    "time": [1],
    "showTimeReference": [1032, "show-time-reference"],
    "timeReference": [1025, "time-reference"],
    "textSelectTime": [1, "text-select-time"],
    "hourInputRef": [32],
    "minuteInputRef": [32],
    "secondInputRef": [32],
    "referenceInputRef": [32],
    "getCurrentTime": [64]
  }]);
function defineCustomElement() {
  if (typeof customElements === "undefined") {
    return;
  }
  const components = ["ix-time-picker", "ix-button", "ix-date-time-card", "ix-icon", "ix-icon-button"];
  components.forEach(tagName => { switch (tagName) {
    case "ix-time-picker":
      if (!customElements.get(tagName)) {
        customElements.define(tagName, TimePicker);
      }
      break;
    case "ix-button":
      if (!customElements.get(tagName)) {
        defineCustomElement$4();
      }
      break;
    case "ix-date-time-card":
      if (!customElements.get(tagName)) {
        defineCustomElement$3();
      }
      break;
    case "ix-icon":
      if (!customElements.get(tagName)) {
        defineCustomElement$2();
      }
      break;
    case "ix-icon-button":
      if (!customElements.get(tagName)) {
        defineCustomElement$1();
      }
      break;
  } });
}

export { TimePicker as T, defineCustomElement as d };

//# sourceMappingURL=time-picker.js.map