import './icon-c659fc0f.js';
export { I as InputState, L as LogicalFilterOperator } from './logical-filter-operator-92531263.js';
export { F as FlipTileState } from './flip-tile-state-051bb2fd.js';
export { c as closeModal, d as dismissModal, m as modal } from './modal-utils-aecbcba5.js';
export { r as renderDefaultItem } from './default-tree-item-91ff2c08.js';
export { U as UploadFileState } from './upload-file-state-532a36d3.js';
export { c as convertToAbbreviationString, a as convertToRemString } from './rwd.util-cfc2ea72.js';
export { T as ThemeSwitcher, t as themeSwitcher } from './theme-switcher-7498e4f2.js';
import './index-8ddfb6d8.js';
import './typed-event-a230184a.js';

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
class FilterState {
}

/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function getToastContainer() {
  const containerList = Array.from(document.querySelectorAll('ix-toast-container'));
  const [container] = containerList;
  if (containerList.length > 1) {
    console.warn('Multiple toast container are found. Only there first is used.');
    return container;
  }
  if (!container) {
    const toastContainer = document.createElement('ix-toast-container');
    document.body.appendChild(toastContainer);
    return toastContainer;
  }
  return container;
}
function setToastPosition(position) {
  getToastContainer().position = position;
}
async function toast(config) {
  const context = getToastContainer();
  const toast = await context.showToast(config);
  return toast;
}
toast.info = (config) => {
  return toast(Object.assign(Object.assign({}, config), { type: 'info' }));
};
toast.error = (config) => {
  return toast(Object.assign(Object.assign({}, config), { type: 'error' }));
};
toast.success = (config) => {
  return toast(Object.assign(Object.assign({}, config), { type: 'success' }));
};
toast.warning = (config) => {
  return toast(Object.assign(Object.assign({}, config), { type: 'warning' }));
};

export { FilterState, getToastContainer, setToastPosition, toast };

//# sourceMappingURL=index.js.map