import { r as registerInstance, c as createEvent, h, H as Host, g as getElement } from './index-8ddfb6d8.js';

const cardAccordionCss = ":host{display:flex;position:relative;flex-direction:column;width:100%;height:2.5rem;max-height:2.5rem;transition:var(--theme-default-time) ease-in-out}:host *,:host *::after,:host *::before{box-sizing:border-box}:host .expand-action{all:unset;display:flex;position:relative;-webkit-appearance:button;-moz-appearance:button;appearance:button;height:2.5rem;width:100%;background-color:var(--theme-color-component-1);align-items:center;justify-content:flex-start}:host .expand-action:not(.disabled):not(:disabled).hover,:host .expand-action:not(.disabled):not(:disabled):hover{background-color:var(--theme-ghost--background--hover)}:host .expand-action:not(.disabled):not(:disabled).active,:host .expand-action:not(.disabled):not(:disabled):active{background-color:var(--theme-ghost--background--active)}:host .expand-action:not(.disabled):not(:disabled):focus-visible{outline:1px solid var(--theme-color-focus-bdr);outline-offset:var(--theme-btn--focus--outline-offset)}:host .expand-action::before{content:\"\";position:absolute;width:100%;height:100%;background-color:var(--ix-card-background);z-index:-1}:host .expand-action:not(.show),:host .expand-action:not(.show)::before{border-bottom-left-radius:var(--theme-default-border-radius);border-bottom-right-radius:var(--theme-default-border-radius)}:host .expand-icon{margin-left:0.5rem;transition:var(--theme-default-time) transform ease-in-out}:host .expand-icon.show{transform:rotate(90deg)}:host .expand-content{display:flex;flex-direction:column;opacity:0;position:absolute;top:2.5rem;transition:var(--theme-default-time) ease-in-out;width:100%;height:0;max-height:20rem;background-color:var(--theme-color-component-1)}:host .expand-content.show{height:15rem;opacity:1}:host .expand-content.show .expand-content-body{display:none;overflow:hidden}:host .expand-content.show .expand-content-body{display:block;overflow:auto}:host .expand-content-footer{display:block;position:relative;width:100%;height:1rem;margin-top:auto;margin-bottom:0px;background-color:var(--theme-color-component-1);border-bottom-left-radius:var(--theme-default-border-radius);border-bottom-right-radius:var(--theme-default-border-radius)}:host(.show){height:calc(15rem + 2.5rem);max-height:calc(15rem + 2.5rem)}";

let accordionControlId = 0;
const getAriaControlsId = (prefix = 'expand-content') => {
  return [prefix, accordionControlId++].join('-');
};
const CardAccordion = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.accordionExpand = createEvent(this, "accordionExpand", 7);
    this.expandContent = false;
  }
  get expandedContent() {
    return this.hostElement.shadowRoot.querySelector('.expand-content');
  }
  onExpandActionClick(event) {
    event.preventDefault();
    event.stopPropagation();
    this.expandContent = !this.expandContent;
    this.accordionExpand.emit({
      expand: this.expandContent,
      nativeEvent: event,
    });
    if (this.expandContent) {
      this.scrollExpandedContentIntoView();
    }
  }
  scrollExpandedContentIntoView() {
    setTimeout(() => {
      const rect = this.expandedContent.getBoundingClientRect();
      if (rect.bottom > window.innerHeight) {
        this.hostElement.shadowRoot
          .querySelector('.expand-content')
          .scrollIntoView(false);
      }
    }, 150);
  }
  render() {
    return (h(Host, { slot: "card-accordion", class: {
        show: this.expandContent,
      } }, h("button", { tabIndex: 0, class: { 'expand-action': true, show: this.expandContent }, onClick: (event) => this.onExpandActionClick(event), role: "button", type: "button", "aria-expanded": this.expandContent, "aria-controls": getAriaControlsId() }, h("ix-icon", { name: "chevron-right-small", class: {
        'expand-icon': true,
        show: this.expandContent,
      } })), h("div", { class: {
        'expand-content': true,
        show: this.expandContent,
      } }, h("div", { class: 'expand-content-body' }, h("slot", null)), h("div", { class: 'expand-content-footer' }))));
  }
  get hostElement() { return getElement(this); }
};
CardAccordion.style = cardAccordionCss;

const cardTitleCss = ":host{display:flex;position:relative;flex-direction:row;align-items:center;padding:0px;margin-bottom:0.5rem;gap:1rem;width:100%}:host .title-actions{display:flex;position:relative;flex-direction:row;gap:0.25rem;margin-left:auto;margin-right:0px}";

const CardHeader = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
  }
  render() {
    return (h(Host, null, h("slot", null), h("div", { class: "title-actions" }, h("slot", { name: "title-actions" }))));
  }
};
CardHeader.style = cardTitleCss;

export { CardAccordion as ix_card_accordion, CardHeader as ix_card_title };

//# sourceMappingURL=ix-card-accordion_2.entry.js.map