import { r as registerInstance, h, H as Host } from './index-8ddfb6d8.js';

const keyValueListCss = ":host(.keyValueList) ::slotted(ix-key-value){border-bottom:1px solid var(--theme-color-weak-bdr)}:host(.keyValueList.keyValueList--striped) ::slotted(ix-key-value:nth-child(odd)){background:var(--theme-color-ghost-alt)}";

const KeyValueList = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.striped = undefined;
  }
  render() {
    return (h(Host, { class: { keyValueList: true, 'keyValueList--striped': this.striped } }, h("slot", null)));
  }
};
KeyValueList.style = keyValueListCss;

export { KeyValueList as ix_key_value_list };

//# sourceMappingURL=ix-key-value-list.entry.js.map