export type ButtonVariant = 'Primary' | 'Secondary';
export declare class Button {
  /**
   * Button variant
   */
  variant: ButtonVariant;
  /**
   * Outline button
   */
  outline: boolean;
  /**
   * Invisible button
   *
   * @deprecated use ghost property
   */
  invisible: boolean;
  /**
   * Button with no background or outline
   */
  ghost: boolean;
  /**
   * Show button as selected. Should be used with outline or ghost
   */
  selected: boolean;
  /**
   * Disable the button
   */
  disabled: boolean;
  /**
   * Type of the button
   */
  type: 'button' | 'submit';
  hostElement: HTMLIxButtonElement;
  /**
   * Temp. workaround until stencil issue is fixed (https://github.com/ionic-team/stencil/issues/2284)
   */
  submitButtonElement: HTMLButtonElement;
  componentDidLoad(): void;
  dispatchFormEvents(): void;
  render(): any;
}
