import { EventEmitter } from '../../stencil-public-runtime';
import { Placement } from './placement';
/**
 * @internal
 */
export type DropdownTriggerEvent = 'click' | 'hover' | 'focus';
export declare class Dropdown {
  hostElement: HTMLIxDropdownElement;
  /**
   * Show dropdown
   */
  show: boolean;
  /**
   * Define an element that triggers the dropdown.
   * A trigger can either be a string that will be interpreted as id attribute or a DOM element.
   */
  trigger: string | HTMLElement;
  /**
   * Define an anchor element
   */
  anchor: string | HTMLElement;
  /**
   * Close behavior
   */
  closeBehavior: 'inside' | 'outside' | 'both' | boolean;
  /**
   * Placement of the dropdown
   */
  placement: Placement;
  /**
   * Position strategy
   */
  positioningStrategy: 'absolute' | 'fixed';
  /**
   * Adjust dropdown width to the parent width
   * @deprecated Will be removed in 2.0.0. Property has a typo use `adjustDropdownWidthToReferenceWidth` instead.
   */
  adjustDropdownWidthToReferenceWith: boolean;
  /**
   * Adjust dropdown width to the parent width
   *
   * @deprecated Will be removed. Not used anymore
   */
  adjustDropdownWidthToReferenceWidth: boolean;
  /**
   * An optional header shown at the top of the dropdown
   */
  header?: string;
  /**
   * Move dropdown along main axis of alignment
   *
   * @internal
   */
  offset: {
    mainAxis?: number;
    crossAxis?: number;
    alignmentAxis?: number;
  };
  /**
   * Define one or more events to open dropdown
   * @internal
   */
  triggerEvent: DropdownTriggerEvent | DropdownTriggerEvent[];
  /**
   * @internal
   */
  overwriteDropdownStyle: (delegate: {
    dropdownRef: HTMLElement;
    triggerRef?: HTMLElement;
  }) => Promise<Partial<CSSStyleDeclaration>>;
  /**
   * Fire event after visibility of dropdown has changed
   */
  showChanged: EventEmitter<boolean>;
  private autoUpdateCleanup;
  private triggerElement?;
  private anchorElement?;
  private dropdownRef;
  private toggleBind;
  private openBind;
  constructor();
  get dropdownItems(): HTMLIxDropdownItemElement[];
  private addEventListenersFor;
  private removeEventListenersFor;
  private registerListener;
  private unregisterListener;
  private resolveElement;
  changedShow(newShow: boolean): Promise<void>;
  changedTrigger(newTriggerValue: string | HTMLElement, oldTriggerValue: string | HTMLElement): void;
  clickOutside(event: Event): void;
  private isNestedDropdown;
  private isAnchorSubmenu;
  private toggle;
  private open;
  private close;
  private applyDropdownPosition;
  componentDidLoad(): Promise<void>;
  componentDidRender(): Promise<void>;
  disconnectedCallback(): void;
  /**
   * Update position of dropdown
   */
  updatePosition(): Promise<void>;
  render(): any;
}
