import { Button, ButtonVariant } from '../button/button';
export type IconButtonVariant = ButtonVariant;
export declare class IconButton implements Button {
  hostElement: HTMLIxIconButtonElement;
  /**
   * Variant of button
   */
  variant: IconButtonVariant;
  /**
   * Button outline
   */
  outline: boolean;
  /**
   * Button invisible
   *
   * @deprecated Use ghost property
   */
  invisible: boolean;
  /**
   * Button invisible
   */
  ghost: boolean;
  /**
   * Button in oval shape
   */
  oval: boolean;
  /**
   * Button icon
   */
  icon: string;
  /**
   * Size of icon in button
   */
  size: '32' | '24' | '16' | '12';
  /**
   * Color of icon in  button
   */
  color: string;
  /**
   * Selected state only working with outline or invisible
   */
  selected: boolean;
  /**
   * Disabled
   */
  disabled: boolean;
  /**
   * Type of the button
   */
  type: 'button' | 'submit';
  /**
   * Temp. workaround until stencil issue is fixed (https://github.com/ionic-team/stencil/issues/2284)
   */
  submitButtonElement: HTMLButtonElement;
  componentDidLoad(): void;
  dispatchFormEvents(): void;
  private getIconSizeClass;
  private getIconButtonClasses;
  render(): any;
}
