import { EventEmitter } from '../../stencil-public-runtime';
export declare class WorkflowStep {
  hostElement: HTMLIxWorkflowStepElement;
  /**
   * Select orientation
   */
  vertical: boolean;
  /**
   * Set disabled
   */
  disabled: boolean;
  /**
   * Set status
   */
  status: 'open' | 'success' | 'done' | 'warning' | 'error';
  /**
   * Activate navigation click
   */
  clickable: boolean;
  /**
   * Set selected
   */
  selected: boolean;
  /**
   * Activate navigation click
   *
   * @deprecated Will be changed to '@internal' in 2.0.0
   */
  position: 'first' | 'last' | 'single' | 'undefined';
  iconName: 'circle' | 'circle-dot' | 'success' | 'warning' | 'error';
  iconColor: string;
  /**
   * @internal
   */
  selectedChanged: EventEmitter<HTMLIxWorkflowStepElement>;
  private customIconSlot;
  private select;
  selectedHandler(): void;
  watchPropHandler(): void;
  componentDidLoad(): void;
  clickFunction(): void;
  render(): any;
}
