import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';

const tileCss = ":host{min-width:11.937rem;max-width:11.937rem;width:11.937rem;display:flex;flex-direction:column;border:1px solid var(--theme-tile--border);border-radius:var(--theme-tile--border-radius);background-color:var(--theme-color-2);color:var(--theme-color-std-text);box-shadow:var(--theme-tile--box-shadow)}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .tile-header{display:flex;align-items:center;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:1rem;font-weight:700;line-height:1.5em;color:var(--theme-color-std-text)}:host .tile-header,:host .tile-subheader,:host .tile-content,:host .tile-footer{padding:0 1rem}:host .tile-header,:host .tile-content{flex-grow:1}:host .tile-header.has-content{display:flex;height:2.5rem;max-height:2.5rem;padding-inline-end:0.5rem}:host .tile-subheader{color:var(--theme-btn-invisible-secondary--color);flex-grow:0}:host .tile-footer.has-content{border-block-start:1px solid var(--theme-color-1);height:2.5rem}:host(.tile-small){height:2.5rem;min-height:2.5rem;max-height:2.5rem}:host(.tile-medium){height:5rem;min-height:5rem;max-height:5rem}:host(.tile-big){height:10rem;min-height:10rem;max-height:10rem}:host(:active),:host(:focus-visible),:host(:visited){outline:none}";
const IxTileStyle0 = tileCss;

const Tile = /*@__PURE__*/ proxyCustomElement(class Tile extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.size = 'medium';
        this.hasHeaderSlot = false;
        this.hasFooterSlot = false;
    }
    handleHeaderSlotChange() {
        this.hasHeaderSlot = !!this.hostElement.querySelector('[slot="header"]');
    }
    handleFooterSlotChange() {
        this.hasFooterSlot = !!this.hostElement.querySelector('[slot="footer"]');
    }
    render() {
        return (h(Host, { key: '16fa86cdf2448b3335401be00cba0284fd166959', class: {
                'tile-small': this.size === 'small',
                'tile-medium': this.size === 'medium',
                'tile-big': this.size === 'big',
            } }, h("div", { key: '0aaf6e763e1bd75f919d1067208af8a33be06937', class: {
                'tile-header': true,
                'has-content': this.hasHeaderSlot,
            } }, h("slot", { key: '70178ba49417bf674cc8798f6824aa37864668f7', name: "header", onSlotchange: () => this.handleHeaderSlotChange() })), h("div", { key: '823a4907cbe143ef6586a5482f31c8729644bf76', class: "tile-subheader" }, h("slot", { key: '6e240f390b24fec6630bed00539479d11d89b096', name: "subheader" })), h("div", { key: '7d83cbe84804423f654e4f9dd0fe3f2ca261a3c4', class: "tile-content" }, h("slot", { key: '100276ea9333c7dd7d183dbd7fb2651475b397cf' })), h("div", { key: 'f73dcff2a9730339deed5c82c0978ff4122dd6a5', class: {
                'tile-footer': true,
                'has-content': this.hasFooterSlot,
            } }, h("slot", { key: 'a550b2cc798c1bc8a57adea6c6fcd4863ad9ac57', name: "footer", onSlotchange: () => this.handleFooterSlotChange() }))));
    }
    get hostElement() { return this; }
    static get style() { return IxTileStyle0; }
}, [1, "ix-tile", {
        "size": [1],
        "hasHeaderSlot": [32],
        "hasFooterSlot": [32]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-tile"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-tile":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, Tile);
            }
            break;
    } });
}

const IxTile = Tile;
const defineCustomElement = defineCustomElement$1;

export { IxTile, defineCustomElement };

//# sourceMappingURL=ix-tile.js.map