/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
export class Tile {
    constructor() {
        this.size = 'medium';
        this.hasHeaderSlot = false;
        this.hasFooterSlot = false;
    }
    handleHeaderSlotChange() {
        this.hasHeaderSlot = !!this.hostElement.querySelector('[slot="header"]');
    }
    handleFooterSlotChange() {
        this.hasFooterSlot = !!this.hostElement.querySelector('[slot="footer"]');
    }
    render() {
        return (h(Host, { key: '16fa86cdf2448b3335401be00cba0284fd166959', class: {
                'tile-small': this.size === 'small',
                'tile-medium': this.size === 'medium',
                'tile-big': this.size === 'big',
            } }, h("div", { key: '0aaf6e763e1bd75f919d1067208af8a33be06937', class: {
                'tile-header': true,
                'has-content': this.hasHeaderSlot,
            } }, h("slot", { key: '70178ba49417bf674cc8798f6824aa37864668f7', name: "header", onSlotchange: () => this.handleHeaderSlotChange() })), h("div", { key: '823a4907cbe143ef6586a5482f31c8729644bf76', class: "tile-subheader" }, h("slot", { key: '6e240f390b24fec6630bed00539479d11d89b096', name: "subheader" })), h("div", { key: '7d83cbe84804423f654e4f9dd0fe3f2ca261a3c4', class: "tile-content" }, h("slot", { key: '100276ea9333c7dd7d183dbd7fb2651475b397cf' })), h("div", { key: 'f73dcff2a9730339deed5c82c0978ff4122dd6a5', class: {
                'tile-footer': true,
                'has-content': this.hasFooterSlot,
            } }, h("slot", { key: 'a550b2cc798c1bc8a57adea6c6fcd4863ad9ac57', name: "footer", onSlotchange: () => this.handleFooterSlotChange() }))));
    }
    static get is() { return "ix-tile"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["tile.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["tile.css"]
        };
    }
    static get properties() {
        return {
            "size": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'small' | 'medium' | 'big'",
                    "resolved": "\"big\" | \"medium\" | \"small\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Size of the tile - one of 'small', 'medium' or 'large'"
                },
                "attribute": "size",
                "reflect": false,
                "defaultValue": "'medium'"
            }
        };
    }
    static get states() {
        return {
            "hasHeaderSlot": {},
            "hasFooterSlot": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=tile.js.map
