/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { expect } from "@playwright/test";
import { regressionTest } from "../utils/test/index";
regressionTest.describe('icon-button', () => {
    regressionTest('basic', async ({ page }) => {
        await page.goto('icon-button/basic');
        expect(await page.screenshot({ fullPage: true })).toMatchSnapshot();
    });
    regressionTest('should show loading spinner', async ({ page }) => {
        await page.goto('icon-button/loading');
        expect(await page.screenshot({ animations: 'disabled' })).toMatchSnapshot();
    });
});
//# sourceMappingURL=icon-button.e2e.js.map
