'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-c6f0ac73.js');

const tileCss = ":host{min-width:11.937rem;max-width:11.937rem;width:11.937rem;display:flex;flex-direction:column;border:1px solid var(--theme-tile--border);border-radius:var(--theme-tile--border-radius);background-color:var(--theme-color-2);color:var(--theme-color-std-text);box-shadow:var(--theme-tile--box-shadow)}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .tile-header{display:flex;align-items:center;-webkit-font-smoothing:antialiased;-moz-osx-font-smooting:grayscale;font-family:Siemens Sans, sans-serif;font-size:1rem;font-weight:700;line-height:1.5em;color:var(--theme-color-std-text)}:host .tile-header,:host .tile-subheader,:host .tile-content,:host .tile-footer{padding:0 1rem}:host .tile-header,:host .tile-content{flex-grow:1}:host .tile-header.has-content{display:flex;height:2.5rem;max-height:2.5rem;padding-inline-end:0.5rem}:host .tile-subheader{color:var(--theme-btn-invisible-secondary--color);flex-grow:0}:host .tile-footer.has-content{border-block-start:1px solid var(--theme-color-1);height:2.5rem}:host(.tile-small){height:2.5rem;min-height:2.5rem;max-height:2.5rem}:host(.tile-medium){height:5rem;min-height:5rem;max-height:5rem}:host(.tile-big){height:10rem;min-height:10rem;max-height:10rem}:host(:active),:host(:focus-visible),:host(:visited){outline:none}";
const IxTileStyle0 = tileCss;

const Tile = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.size = 'medium';
        this.hasHeaderSlot = false;
        this.hasFooterSlot = false;
    }
    handleHeaderSlotChange() {
        this.hasHeaderSlot = !!this.hostElement.querySelector('[slot="header"]');
    }
    handleFooterSlotChange() {
        this.hasFooterSlot = !!this.hostElement.querySelector('[slot="footer"]');
    }
    render() {
        return (index.h(index.Host, { key: 'c0d60ca326a0a16f2255ae8a755f03a86c4c2bdf', class: {
                'tile-small': this.size === 'small',
                'tile-medium': this.size === 'medium',
                'tile-big': this.size === 'big',
            } }, index.h("div", { key: 'b43e41051b62b8146749b884c9d611f79b6bf9c8', class: {
                'tile-header': true,
                'has-content': this.hasHeaderSlot,
            } }, index.h("slot", { key: '3dc74cc4beb1b24023463d62daf862c28ba2177a', name: "header", onSlotchange: () => this.handleHeaderSlotChange() })), index.h("div", { key: '4935b7758861eab0fd305ceccba9d4d3a7cc90de', class: "tile-subheader" }, index.h("slot", { key: '31d66eb3e361c0b811ab3c0f89976c39f3576629', name: "subheader" })), index.h("div", { key: '083b54d5455f1015811c904826dda8fb2b35a243', class: "tile-content" }, index.h("slot", { key: '14c79b5d8365444f234c030c56b2592b7cb38dc8' })), index.h("div", { key: 'a12114c3593b8032aa4e5d841efc55723deb7b44', class: {
                'tile-footer': true,
                'has-content': this.hasFooterSlot,
            } }, index.h("slot", { key: 'aa1f08fe633554658a5119cd7d61febb3928e8f4', name: "footer", onSlotchange: () => this.handleFooterSlotChange() }))));
    }
    get hostElement() { return index.getElement(this); }
};
Tile.style = IxTileStyle0;

exports.ix_tile = Tile;

//# sourceMappingURL=ix-tile.cjs.entry.js.map