'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-c6f0ac73.js');
const mutationObserver = require('./mutation-observer-babb20a5.js');

const workflowStepsCss = ":host{}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .steps{display:flex}:host .steps.vertical{display:block}";
const IxWorkflowStepsStyle0 = workflowStepsCss;

const WorkflowSteps = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.stepSelected = index.createEvent(this, "stepSelected", 7);
        this.vertical = false;
        this.clickable = false;
        this.selectedIndex = 0;
    }
    getSteps() {
        return Array.from(this.hostElement.querySelectorAll('ix-workflow-step'));
    }
    updateSteps() {
        let steps = this.getSteps();
        steps.forEach((element, index) => {
            element.vertical = this.vertical;
            element.clickable = this.clickable;
            element.selected = this.selectedIndex === index;
            if (steps.length === 1) {
                element.position = 'single';
                return;
            }
            if (index === 0) {
                element.position = 'first';
            }
            else if (index === steps.length - 1) {
                element.position = 'last';
            }
            else {
                element.position = 'undefined';
            }
        });
    }
    onStepSelectionChanged(event) {
        const eventTarget = event.detail;
        const steps = this.getSteps();
        const clickIndex = steps.findIndex((step) => step === eventTarget);
        const clientEvent = this.stepSelected.emit(clickIndex);
        if (clientEvent.defaultPrevented) {
            return;
        }
        steps.forEach((step, index) => {
            step.selected = index === clickIndex;
        });
    }
    componentWillLoad() {
        this.updateSteps();
    }
    componentDidLoad() {
        this.observer = mutationObserver.createMutationObserver((mutations) => {
            for (let mutation of mutations) {
                if (mutation.type === 'childList') {
                    this.updateSteps();
                }
            }
        });
        this.observer.observe(this.hostElement, { childList: true });
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    componentDidRender() {
        this.updateSteps();
    }
    render() {
        return (index.h(index.Host, { key: 'fadad485a71a3366872450c53c089d6f4b79702d' }, index.h("div", { key: 'eda4300c1de1abe221e2051e2d38f3509e682fbe', class: { steps: true, vertical: this.vertical } }, index.h("slot", { key: 'c79f023401cc03cc5de9117d00de66885987085a' }))));
    }
    get hostElement() { return index.getElement(this); }
};
WorkflowSteps.style = IxWorkflowStepsStyle0;

exports.ix_workflow_steps = WorkflowSteps;

//# sourceMappingURL=ix-workflow-steps.cjs.entry.js.map