/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { hasSlottedElements } from "../utils/shadow-dom";
/**
 * @since 2.1.0
 * @slot header - Display content at the top of the content page
 */
export class Content {
    constructor() {
        this.isContentHeaderSlotted = false;
    }
    get contentHeaderSlot() {
        return this.hostElement.shadowRoot.querySelector('.content-header slot');
    }
    render() {
        return (h(Host, { key: '7298c4abd09355a3ee73d4a236e7025a72720cf7' }, h("div", { key: 'd7ba3fbc44d66ba0ae4e747a5cc5d77c7388b138', class: {
                'content-header': true,
                slotted: this.isContentHeaderSlotted,
            } }, h("slot", { key: '233200870318a9276d3e0d5c5d5d03980fbe1793', name: "header", onSlotchange: () => {
                this.isContentHeaderSlotted = hasSlottedElements(this.contentHeaderSlot);
            } })), h("div", { key: 'ee7f8ceb237b4c33d578262c74d4eca9bdf36070', class: "content" }, h("slot", { key: 'fbbf86e9c454f04dbe33a9b0456f1cd02ec72c02' }))));
    }
    static get is() { return "ix-content"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["content.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["content.css"]
        };
    }
    static get states() {
        return {
            "isContentHeaderSlotted": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=content.js.map
