/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { createMutationObserver } from "../utils/mutation-observer";
import { FlipTileState } from "./flip-tile-state";
export class FlipTile {
    constructor() {
        this.ANIMATION_DURATION = 150;
        this.state = undefined;
        this.height = 15.125;
        this.width = 16;
        this.index = 0;
        this.isFlipAnimationActive = undefined;
    }
    componentDidLoad() {
        this.observer = createMutationObserver(() => this.updateContentItems());
        this.observer.observe(this.hostElement, {
            childList: true,
        });
    }
    componentWillLoad() {
        this.updateContentItems();
        this.updateContentVisibility(this.index);
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    updateContentItems() {
        this.contentItems = Array.from(this.hostElement.querySelectorAll('ix-flip-tile-content'));
    }
    updateContentVisibility(indexVisible) {
        this.contentItems.forEach((content, index) => (content.contentVisible = index === indexVisible));
    }
    toggleIndex() {
        this.doFlipAnimation();
    }
    doFlipAnimation() {
        this.isFlipAnimationActive = true;
        setTimeout(() => {
            this.updateContentVisibility(this.index);
            if (this.index >= this.contentItems.length - 1) {
                this.index = 0;
            }
            else {
                this.index++;
            }
            this.updateContentVisibility(this.index);
        }, this.ANIMATION_DURATION);
        setTimeout(() => {
            this.isFlipAnimationActive = false;
        }, 2 * this.ANIMATION_DURATION);
    }
    render() {
        return (h(Host, { key: '0b942337cb77e1cb7727d016e3a9a571f86582de', style: {
                height: `${this.height}${this.height === 'auto' ? '' : 'rem'}`,
                'min-height': `${this.height}${this.height === 'auto' ? '' : 'rem'}`,
                'max-height': `${this.height}${this.height === 'auto' ? '' : 'rem'}`,
                width: `${this.width}${this.width === 'auto' ? '' : 'rem'}`,
                'min-width': `${this.width}${this.width === 'auto' ? '' : 'rem'}`,
                'max-width': `${this.width}${this.width === 'auto' ? '' : 'rem'}`,
            } }, h("div", { key: '3c2b6418b48c676358608e08cd878f912327aa8a', class: {
                'flip-tile-container': true,
                info: this.state === FlipTileState.Info,
                warning: this.state === FlipTileState.Warning,
                alarm: this.state === FlipTileState.Alarm,
                primary: this.state === FlipTileState.Primary,
                'flip-animation-active': this.isFlipAnimationActive,
            } }, h("div", { key: 'bc46de76725d49e89f0d0b3fb30908bd84918b1b', class: "flip-tile-header" }, h("div", { key: 'c42c692b8f5e1d03eaa3b02c0344fc3766754522', class: "header-slot-container text-l-title" }, h("slot", { key: 'b382eb85bb86f8026aefb1e1679278ab36d3a141', name: "header" })), h("ix-icon-button", { key: 'a7fbd03314c3fc5973c84656265114aca26458ce', icon: 'eye', variant: "primary", ghost: true, onClick: () => this.toggleIndex() })), h("div", { key: '2902c41ee142c4185af4f01dfb9fd18a2180769e', class: "content-container" }, h("slot", { key: 'abe7abe1590d698591ce64b9072cb26e16935fab' })), h("div", { key: 'f265f08af13cac0f5a52750d45fd0d51e1d5fb52', class: {
                footer: true,
                'contrast-light': this.state === FlipTileState.Warning,
                'contrast-dark': this.state === FlipTileState.Info ||
                    this.state === FlipTileState.Alarm,
            } }, h("slot", { key: 'f95f6d923988154f23faef4780cfc34a332cb31b', name: "footer" })))));
    }
    static get is() { return "ix-flip-tile"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["flip-tile.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["flip-tile.css"]
        };
    }
    static get properties() {
        return {
            "state": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "FlipTileState",
                    "resolved": "FlipTileState.Alarm | FlipTileState.Info | FlipTileState.None | FlipTileState.Primary | FlipTileState.Warning",
                    "references": {
                        "FlipTileState": {
                            "location": "import",
                            "path": "./flip-tile-state",
                            "id": "src/components/flip-tile/flip-tile-state.ts::FlipTileState"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Variation of the Flip"
                },
                "attribute": "state",
                "reflect": false
            },
            "height": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "number | 'auto'",
                    "resolved": "\"auto\" | number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "1.5.0"
                        }],
                    "text": "Height interpreted as REM"
                },
                "attribute": "height",
                "reflect": false,
                "defaultValue": "15.125"
            },
            "width": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "number | 'auto'",
                    "resolved": "\"auto\" | number",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "since",
                            "text": "1.5.0"
                        }],
                    "text": "Width interpreted as REM"
                },
                "attribute": "width",
                "reflect": false,
                "defaultValue": "16"
            }
        };
    }
    static get states() {
        return {
            "index": {},
            "isFlipAnimationActive": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=flip-tile.js.map
