/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
export class FormField {
    constructor() {
        this.label = undefined;
    }
    get inputElement() {
        return this.hostElement.querySelector('input');
    }
    componentWillLoad() { }
    render() {
        return (h(Host, { key: 'e1313ac6762c322974a1a69f030c18e91c63d958' }, this.label ? (h("label", { htmlFor: this.inputElement.id }, this.label)) : null, h("slot", { key: 'fbbe9a9eefffdce4b888d3dfb3ec80b1e6c8111d' })));
    }
    static get is() { return "ix-form-field"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["form-field.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["form-field.css"]
        };
    }
    static get properties() {
        return {
            "label": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Label"
                },
                "attribute": "label",
                "reflect": false
            }
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=form-field.js.map
