/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { getSlottedElements } from "../utils/shadow-dom";
export class GroupContextMenu {
    constructor() {
        this.showContextMenu = false;
    }
    getTrigger() {
        return this.hostElement;
    }
    configureDropdown(dropdownElement, triggerElement) {
        dropdownElement.positioningStrategy = 'fixed';
        dropdownElement.trigger = triggerElement;
    }
    onSlotChange() {
        const slot = this.hostElement.shadowRoot.querySelector('slot');
        if (!slot) {
            return;
        }
        const elements = getSlottedElements(slot);
        this.showContextMenu = elements.length !== 0;
        const dropdownElement = elements.find((elm) => elm.tagName === 'IX-DROPDOWN');
        const triggerElement = this.getTrigger();
        if (!triggerElement) {
            return;
        }
        if (!dropdownElement) {
            return;
        }
        this.configureDropdown(dropdownElement, triggerElement);
    }
    render() {
        return (h(Host, { key: '288d46637e80e99a79a01e071d69a77582edf051' }, h("ix-icon-button", { key: '7c9ad1282215761c6d160799971114cc3533e30a', class: { hide: !this.showContextMenu }, size: "24", ghost: true, icon: 'context-menu' }), h("slot", { key: 'c80375c5028e87d03c5af3b3deaa45fa2958e11f', onSlotchange: () => this.onSlotChange() })));
    }
    static get is() { return "ix-group-context-menu"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["./group-context-menu.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["group-context-menu.css"]
        };
    }
    static get states() {
        return {
            "showContextMenu": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=group-context-menu.js.map
