/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @since 2.0.0
 */
export class LinkButton {
    constructor() {
        this.disabled = false;
        this.url = undefined;
        this.target = '_self';
    }
    render() {
        return (h(Host, { key: '52fa8b05a14564aa2d422fe3a2612224854b37a6' }, h("a", { key: '301f380e66162b16624c15048f7f3082aac9b334', title: this.url, tabindex: "0", class: {
                'link-button': true,
                disabled: this.disabled,
            }, href: this.disabled ? undefined : this.url, target: this.target }, h("ix-icon", { key: 'ed0b948e2a66635d666db533fbdcf63c321b76d9', class: "icon", name: 'chevron-right-small', size: "16" }), h("div", { key: '20c5ff5cc5c3b9e4974d866a30c928874711f4e1', class: {
                link: true,
                disabled: this.disabled,
            } }, h("slot", { key: 'b36befb3534304704d320efca6c8b825156394cc' })))));
    }
    static get is() { return "ix-link-button"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["link-button.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["link-button.css"]
        };
    }
    static get properties() {
        return {
            "disabled": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Disable the link button"
                },
                "attribute": "disabled",
                "reflect": false,
                "defaultValue": "false"
            },
            "url": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Url for the link button"
                },
                "attribute": "url",
                "reflect": false
            },
            "target": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "'_self' | '_blank' | '_parent' | '_top'",
                    "resolved": "\"_blank\" | \"_parent\" | \"_self\" | \"_top\"",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Specifies where to open the link\n\nhttps://www.w3schools.com/html/html_links.asp"
                },
                "attribute": "target",
                "reflect": false,
                "defaultValue": "'_self'"
            }
        };
    }
}
//# sourceMappingURL=link-button.js.map
