/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { getButtonClasses } from "../button/base-button";
import { a11yBoolean } from "../utils/a11y";
/**
 * @internal
 */
export class MenuExpandIcon {
    constructor() {
        this.ixAriaLabel = 'Expand';
        this.expanded = false;
        this.breakpoint = undefined;
        this.pinned = false;
    }
    getSmallScreenIcon() {
        return (h("button", { class: Object.assign(Object.assign({}, getButtonClasses('secondary', false, true, true, false, false, false)), { 'menu-expand-button': true }), type: "button", "aria-label": this.ixAriaLabel ? this.ixAriaLabel : null, "aria-pressed": a11yBoolean(this.expanded) }, h("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 24 24", width: "24", height: "24" }, h("rect", { class: "line line-1", x: "2", y: "5", width: "20", height: "2" }), h("rect", { class: "line line-2", x: "2", y: "11", width: "13", height: "2" }), h("rect", { class: "line line-3", x: "2", y: "17", width: "20", height: "2" }))));
    }
    getLargeScreenIcon() {
        return (h("ix-icon-button", { icon: `double-chevron-${this.expanded ? 'left' : 'right'}`, ghost: true }));
    }
    getMenuIcon() {
        if (this.pinned) {
            return this.getLargeScreenIcon();
        }
        if (this.breakpoint === 'md') {
            return this.getLargeScreenIcon();
        }
        if (this.breakpoint === 'lg') {
            return this.getLargeScreenIcon();
        }
        return this.getSmallScreenIcon();
    }
    render() {
        return (h(Host, { key: '36ee1cac55573a7413f6fd89635987a1a38d3a1d', class: {
                expanded: this.expanded,
            } }, this.getMenuIcon()));
    }
    static get is() { return "ix-menu-expand-icon"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["./menu-expand-icon.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["menu-expand-icon.css"]
        };
    }
    static get properties() {
        return {
            "ixAriaLabel": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "string",
                    "resolved": "string",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Accessibility label for the menu expand icon (MANDATORY)"
                },
                "attribute": "ix-aria-label",
                "reflect": false,
                "defaultValue": "'Expand'"
            },
            "expanded": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Whether the menu expand icon displays the expanded state or not"
                },
                "attribute": "expanded",
                "reflect": true,
                "defaultValue": "false"
            },
            "breakpoint": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "Breakpoint",
                    "resolved": "\"lg\" | \"md\" | \"sm\"",
                    "references": {
                        "Breakpoint": {
                            "location": "import",
                            "path": "../utils/breakpoints",
                            "id": "src/components/utils/breakpoints.ts::Breakpoint"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Controls which icon is displayed"
                },
                "attribute": "breakpoint",
                "reflect": true
            },
            "pinned": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Display as pinned"
                },
                "attribute": "pinned",
                "reflect": false,
                "defaultValue": "false"
            }
        };
    }
}
//# sourceMappingURL=menu-expand-icon.js.map
