import { r as registerInstance, c as createEvent, h, H as Host, g as getElement } from './index-f18c5ad1.js';
import { a as anime } from './anime.es-a5520566.js';
import { c as closestIxMenu } from './context-c9078420.js';
import { c as createMutationObserver } from './mutation-observer-db8757e6.js';
import './typed-event-ad6484c5.js';

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function createEnterLeaveDebounce(enterCallback, leaveCallback, { debounceTimeEnter, debounceTimeLeave, } = {
    debounceTimeEnter: 0,
    debounceTimeLeave: 500,
}) {
    let enterTimeout;
    let leaveTimeout;
    return {
        onEnter: () => {
            clearTimeout(leaveTimeout);
            enterTimeout = setTimeout(() => {
                enterCallback();
            }, debounceTimeEnter);
        },
        onLeave: () => {
            clearTimeout(enterTimeout);
            leaveTimeout = setTimeout(() => {
                leaveCallback();
            }, debounceTimeLeave);
        },
    };
}

const menuCategoryCss = ":host{display:flex;flex-direction:column;position:relative}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .category{display:flex;position:relative;align-items:center;width:100%;height:100%}:host .category-text{width:100%;padding-right:0.25rem;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}:host .category-chevron{margin-left:auto;margin-right:0;transition:var(--theme-default-time) transform ease-in-out}:host .category-chevron--open{transform:rotate(-180deg)}:host .menu-items{overflow:hidden;max-height:0;transition:var(--theme-default-time) max-height ease-in-out}:host .menu-items--expanded{max-height:999999999px;padding:0.25rem 0 0.25rem 1.625rem}:host .menu-items--collapsed{display:none}:host .category-dropdown ::slotted(ix-menu-item){--ix-menu-item-height:2.5rem}:host .category-dropdown-header{pointer-events:none;padding-left:0.125rem;min-width:256px}:host ::slotted(ix-menu-item){--ix-menu-item-height:2.5rem}:host(.expanded){background-color:var(--theme-color-ghost--active)}:host ::slotted(a[href]){text-decoration:none !important}";
const IxMenuCategoryStyle0 = menuCategoryCss;

const DefaultIxMenuItemHeight = 40;
const DefaultAnimationTimeout = 150;
const MenuCategory = class {
    constructor(hostRef) {
        registerInstance(this, hostRef);
        this.closeOtherCategories = createEvent(this, "closeOtherCategories", 7);
        this.enterLeaveDebounce = createEnterLeaveDebounce(() => {
            this.onPointerEnter();
        }, () => {
            this.onPointerLeave();
        });
        this.label = undefined;
        this.icon = undefined;
        this.notifications = undefined;
        this.menuExpand = false;
        this.showItems = false;
        this.showDropdown = false;
        this.nestedItems = [];
    }
    isNestedItemActive() {
        return this.getNestedItems().some((item) => item.active);
    }
    getNestedItems() {
        return Array.from(this.hostElement.querySelectorAll(':scope ix-menu-item'));
    }
    getNestedItemsHeight() {
        const items = this.getNestedItems();
        return items.length * DefaultIxMenuItemHeight;
    }
    onExpandCategory(showItems) {
        if (showItems) {
            this.animateFadeIn();
        }
        else {
            this.animateFadeOut();
        }
    }
    animateFadeOut() {
        const slotHideThresholdMs = 25;
        anime({
            targets: this.menuItemsContainer,
            duration: DefaultAnimationTimeout,
            easing: 'easeInSine',
            opacity: [1, 0],
            maxHeight: [this.getNestedItemsHeight() + DefaultIxMenuItemHeight, 0],
            complete: () => {
                setTimeout(() => {
                    this.showItems = false;
                    this.showDropdown = false;
                }, DefaultAnimationTimeout + slotHideThresholdMs);
            },
        });
    }
    animateFadeIn() {
        anime({
            targets: this.menuItemsContainer,
            duration: DefaultAnimationTimeout,
            easing: 'easeInSine',
            opacity: [0, 1],
            maxHeight: [0, this.getNestedItemsHeight() + DefaultIxMenuItemHeight],
            begin: () => {
                this.showItems = true;
                this.showDropdown = false;
            },
        });
    }
    onPointerEnter() {
        if (this.ixMenu.expand) {
            return;
        }
        this.closeOtherCategories.emit();
        this.showDropdown = true;
    }
    onPointerLeave() {
        this.showDropdown = false;
    }
    onCategoryClick(e) {
        e.stopPropagation();
        if (this.ixMenu.expand) {
            e === null || e === void 0 ? void 0 : e.stopPropagation();
            this.onExpandCategory(!this.showItems);
            return;
        }
    }
    onNestedItemsChanged() {
        this.nestedItems = this.getNestedItems();
    }
    isCategoryItemListVisible() {
        return this.menuExpand && (this.showItems || this.isNestedItemActive());
    }
    componentWillLoad() {
        const closestMenu = closestIxMenu(this.hostElement);
        if (!closestMenu) {
            throw Error('ix-menu-category can only be used as a child of ix-menu');
        }
        this.ixMenu = closestMenu;
        this.menuExpand = this.ixMenu.expand;
        this.showItems = this.isCategoryItemListVisible();
    }
    componentDidLoad() {
        this.observer = createMutationObserver(() => this.onNestedItemsChanged());
        this.observer.observe(this.hostElement, {
            attributes: true,
            childList: true,
            subtree: true,
        });
        requestAnimationFrame(() => {
            this.onNestedItemsChanged();
        });
        this.ixMenu.addEventListener('expandChange', ({ detail: menuExpand }) => {
            this.menuExpand = menuExpand;
            if (!menuExpand) {
                this.clearMenuItemStyles();
            }
            this.showItems = this.isCategoryItemListVisible();
        });
    }
    clearMenuItemStyles() {
        this.menuItemsContainer.style.removeProperty('max-height');
        this.menuItemsContainer.style.removeProperty('opacity');
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    render() {
        return (h(Host, { key: '17d25dacba5afe08d75eb84c1063856e79efa255', class: {
                expanded: this.showItems,
            }, onPointerEnter: () => {
                this.enterLeaveDebounce.onEnter();
            }, onPointerLeave: (event) => {
                if (event.pointerType === 'touch') {
                    return;
                }
                this.enterLeaveDebounce.onLeave();
            } }, h("ix-menu-item", { key: '3d7cc544297fbf21c5948bd390f9a65fa3e9892f', class: 'category-parent', active: this.isNestedItemActive(), notifications: this.notifications, icon: this.icon, onClick: (e) => this.onCategoryClick(e), onFocus: () => this.onPointerEnter(), isCategory: true }, h("div", { key: '44cf05761426822b2a0d5ad7b43bc0ac84b66ef2', class: "category" }, h("div", { key: '7d0c2c9efff3d54e3ed5eb0f19294703f7cf853f', class: "category-text" }, this.label), h("ix-icon", { key: '1eeb7a9da2b3b2cbf9f2b37f1e7d42162b7f65e5', name: 'chevron-down-small', class: {
                'category-chevron': true,
                'category-chevron--open': this.showItems,
            } }))), h("div", { key: '783ec3ecb6153f12b43a2f3733b672d9af6390df', ref: (ref) => (this.menuItemsContainer = ref), class: {
                'menu-items': true,
                'menu-items--expanded': this.showItems,
                'menu-items--collapsed': !this.showItems,
            } }, this.showItems ? h("slot", null) : null), h("ix-dropdown", { key: '8f7c5bf15a51ca3a57a50e259caa691ffce7a6dd', closeBehavior: 'both', show: this.showDropdown, onShowChanged: ({ detail: dropdownShown }) => {
                this.showDropdown = dropdownShown;
            }, class: 'category-dropdown', anchor: this.hostElement, placement: "right-start", offset: {
                mainAxis: 3,
            }, onClick: (e) => {
                if (e.target instanceof HTMLElement) {
                    if (e.target.tagName === 'IX-MENU-ITEM') {
                        this.showDropdown = false;
                    }
                }
            } }, h("ix-dropdown-item", { key: 'e5f9d6b9ea910dcb852da7bdffec8117bd0fdf6e', class: 'category-dropdown-header' }, h("ix-typography", { key: '5e8ce8f52f2c089ffabd36e3345c46b83b07a554', variant: "default-title-single", color: "std" }, this.label)), h("ix-divider", { key: 'ebadc6189f93ab6e25262b324259993eaa557400' }), h("slot", { key: 'f9d0e1a321e824390671e380094c78c22f67d428' }))));
    }
    get hostElement() { return getElement(this); }
};
MenuCategory.style = IxMenuCategoryStyle0;

export { MenuCategory as ix_menu_category };

//# sourceMappingURL=ix-menu-category.entry.js.map