import { proxyCustomElement, HTMLElement, h, Host } from '@stencil/core/internal/client';
import { d as defineCustomElement$6 } from './card.js';
import { d as defineCustomElement$5 } from './card-accordion.js';
import { d as defineCustomElement$4 } from './card-content.js';
import { d as defineCustomElement$3 } from './card-title.js';
import { d as defineCustomElement$2 } from './typography.js';

const pushCardCss = ":host{display:block;position:relative}:host .icon{transform:scale(1.25)}:host .notification{font-size:40px}:host ix-card-content{height:11rem}";
const IxPushCardStyle0 = pushCardCss;

const PushCard = /*@__PURE__*/ proxyCustomElement(class PushCard extends HTMLElement {
    constructor() {
        super();
        this.__registerHost();
        this.__attachShadow();
        this.icon = undefined;
        this.notification = undefined;
        this.heading = undefined;
        this.subheading = undefined;
        this.variant = 'insight';
        this.collapse = true;
    }
    render() {
        var _a;
        const color = this.variant === 'insight' || this.variant === 'notification'
            ? 'std'
            : undefined;
        return (h(Host, { key: '9ba9fd8e6cc9f2b74e89fbbcd0c09a04aca45ac2' }, h("ix-card", { key: '913618b3fc69c1e59c3bbeb4c92569b2754ff3ae', variant: this.variant }, h("ix-card-content", { key: 'bb75a940ce3ac891fe947f4ed9e542c36a492f92' }, h("ix-card-title", { key: '37f4faab2368f341dd835fffe64b5915e1c4b322' }, this.icon ? (h("ix-icon", { class: 'icon', name: this.icon, size: "32" })) : null, h("span", { key: '42059a2ed174f15fdcce1ddb599bc831afade5b1', class: 'notification' }, (_a = this.notification) !== null && _a !== void 0 ? _a : 0), h("slot", { key: '9e3b8df6148f3b8e3d577d8ece5253b14c85a0dd', name: "title-action" })), h("ix-typography", { key: 'b7473e9fd9fdaee3045ec4884544469a9a6457fe', color: color, format: "h4" }, this.heading), h("ix-typography", { key: '26c212e7f6111df4d353525fda6b3a76ee7dea3c', color: color }, this.subheading)), h("ix-card-accordion", { key: 'a779591ee7405f4a725f1c04abbc7223064ee885', collapse: this.collapse }, h("slot", { key: '5d42faa67c254a1d8541c525cb8e0e08e6b0d095' })))));
    }
    static get style() { return IxPushCardStyle0; }
}, [1, "ix-push-card", {
        "icon": [1],
        "notification": [1],
        "heading": [1],
        "subheading": [1],
        "variant": [1],
        "collapse": [4]
    }]);
function defineCustomElement$1() {
    if (typeof customElements === "undefined") {
        return;
    }
    const components = ["ix-push-card", "ix-card", "ix-card-accordion", "ix-card-content", "ix-card-title", "ix-typography"];
    components.forEach(tagName => { switch (tagName) {
        case "ix-push-card":
            if (!customElements.get(tagName)) {
                customElements.define(tagName, PushCard);
            }
            break;
        case "ix-card":
            if (!customElements.get(tagName)) {
                defineCustomElement$6();
            }
            break;
        case "ix-card-accordion":
            if (!customElements.get(tagName)) {
                defineCustomElement$5();
            }
            break;
        case "ix-card-content":
            if (!customElements.get(tagName)) {
                defineCustomElement$4();
            }
            break;
        case "ix-card-title":
            if (!customElements.get(tagName)) {
                defineCustomElement$3();
            }
            break;
        case "ix-typography":
            if (!customElements.get(tagName)) {
                defineCustomElement$2();
            }
            break;
    } });
}

const IxPushCard = PushCard;
const defineCustomElement = defineCustomElement$1;

export { IxPushCard, defineCustomElement };

//# sourceMappingURL=ix-push-card.js.map