'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-529f21c1.js');
const shadowDom = require('./shadow-dom-73f9d553.js');

const menuAvatarCss = ":host{display:block;position:relative;margin-bottom:0.5rem;margin-right:0.75rem}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){:host *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .avatar{all:unset;box-sizing:border-box;display:flex;align-items:center;height:2.5rem;width:100%;max-height:2.5rem;padding-left:0.25rem;margin-left:0.41rem;margin-right:0.35rem;transition:var(--theme-default-time);border-radius:1.25rem}:host .avatar .avatar-name{display:flex;flex-direction:column;overflow:hidden;white-space:nowrap;margin-left:1rem;line-height:1.14}:host .avatar .avatar-name .text-default-single{color:var(--theme-nav-item-primary--color);overflow:hidden;text-overflow:ellipsis;white-space:nowrap}:host .avatar:not(.disabled):not(:disabled){cursor:pointer}:host .avatar:not(.disabled):not(:disabled):hover{background-color:var(--theme-avatar-btn--background--hover);color:var(--theme-avatar-btn--color--hover)}:host .avatar:not(.disabled):not(:disabled){cursor:pointer}:host .avatar:not(.disabled):not(:disabled):active,:host .avatar:not(.disabled):not(:disabled).active{background-color:var(--theme-avatar-btn--background--active);color:var(--theme-avatar-btn--color--active)}:host .avatar:focus-visible{outline:1px solid var(--theme-color-focus-bdr)}";
const IxMenuAvatarStyle0 = menuAvatarCss;

const MenuAvatar = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.logoutClick = index.createEvent(this, "logoutClick", 7);
        this.avatarElementId = 'ix-menu-avatar-id';
        this.top = undefined;
        this.bottom = undefined;
        this.image = undefined;
        this.initials = undefined;
        this.i18nLogout = 'Logout';
        this.showLogoutButton = true;
        this.showContextMenu = false;
    }
    onSlotChange() {
        const slot = this.hostElement.shadowRoot.querySelector('slot');
        if (!slot) {
            return;
        }
        const elements = shadowDom.getSlottedElements(slot);
        this.showContextMenu = elements.length !== 0;
    }
    render() {
        return (index.h(index.Host, { key: '61992b9228865de22f97b9339744ba17c7ffc302', slot: "ix-menu-avatar" }, index.h("button", { key: 'a6347e7de8797fe19cb42e529a7cfd0df742e018', class: "nav-item top-item avatar no-hover", title: this.top, id: this.avatarElementId, tabIndex: 0 }, index.h("ix-avatar", { key: '7af0a4778306d565dc9230c5cb140e4ace0c2e5c', image: this.image, initials: this.initials }), index.h("div", { key: '614a3ae7823ac740d9ed889ccce9de4f6443675d', class: "avatar-name" }, index.h("span", { key: '6771ab0dff5bfc26f6cf572581badb74a19cc76d', class: "text-default-single", title: this.top }, this.top), index.h("span", { key: 'd238d0aff82b3714628ba259118169bd87cd7782', class: "text-default-single", title: this.bottom }, this.bottom))), index.h("ix-dropdown", { key: '29048d3d0063d283fb30e8355fc21cb29675bd96', trigger: this.hostElement, placement: 'right-start', hidden: !this.showContextMenu && !this.showLogoutButton, offset: {
                mainAxis: 16,
            } }, index.h("slot", { key: 'dc8d7882a69d777d54e5f175ccfeabc946599b51', onSlotchange: () => this.onSlotChange() }), this.showLogoutButton ? (index.h("ix-menu-avatar-item", { label: this.i18nLogout, icon: 'log-out', onClick: (e) => {
                this.logoutClick.emit(e);
            } })) : null)));
    }
    get hostElement() { return index.getElement(this); }
};
MenuAvatar.style = IxMenuAvatarStyle0;

exports.ix_menu_avatar = MenuAvatar;

//# sourceMappingURL=ix-menu-avatar.cjs.entry.js.map