'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-529f21c1.js');
const anime_es = require('./anime.es-e2814360.js');
const context = require('./context-98f4a0b3.js');
const mutationObserver = require('./mutation-observer-babb20a5.js');
require('./typed-event-8032c0c0.js');

/*
 * SPDX-FileCopyrightText: 2024 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
function createEnterLeaveDebounce(enterCallback, leaveCallback, { debounceTimeEnter, debounceTimeLeave, } = {
    debounceTimeEnter: 0,
    debounceTimeLeave: 500,
}) {
    let enterTimeout;
    let leaveTimeout;
    return {
        onEnter: () => {
            clearTimeout(leaveTimeout);
            enterTimeout = setTimeout(() => {
                enterCallback();
            }, debounceTimeEnter);
        },
        onLeave: () => {
            clearTimeout(enterTimeout);
            leaveTimeout = setTimeout(() => {
                leaveCallback();
            }, debounceTimeLeave);
        },
    };
}

const menuCategoryCss = ":host{display:flex;flex-direction:column;position:relative}:host *,:host *::after,:host *::before{box-sizing:border-box}:host ::-webkit-scrollbar-button{display:none}@-moz-document url-prefix(){:host *{scrollbar-color:var(--theme-scrollbar-thumb--background) var(--theme-scrollbar-track--background);scrollbar-width:thin}}:host ::-webkit-scrollbar{width:0.5rem;height:0.5rem}:host ::-webkit-scrollbar-track{border-radius:5px;background:var(--theme-scrollbar-track--background)}:host ::-webkit-scrollbar-track:hover{background:var(--theme-scrollbar-track--background--hover)}:host ::-webkit-scrollbar-thumb{border-radius:5px;background:var(--theme-scrollbar-thumb--background)}:host ::-webkit-scrollbar-thumb:hover{background:var(--theme-scrollbar-thumb--background--hover)}:host ::-webkit-scrollbar-corner{display:none}:host .category{display:flex;position:relative;align-items:center;width:100%;height:100%}:host .category-text{width:100%;padding-right:0.25rem;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}:host .category-chevron{margin-left:auto;margin-right:0;transition:var(--theme-default-time) transform ease-in-out}:host .category-chevron--open{transform:rotate(-180deg)}:host .menu-items{overflow:hidden;max-height:0;transition:var(--theme-default-time) max-height ease-in-out}:host .menu-items--expanded{max-height:999999999px;padding:0.25rem 0 0.25rem 1.625rem}:host .menu-items--collapsed{display:none}:host .category-dropdown ::slotted(ix-menu-item){--ix-menu-item-height:2.5rem}:host .category-dropdown-header{pointer-events:none;padding-left:0.125rem;min-width:256px}:host ::slotted(ix-menu-item){--ix-menu-item-height:2.5rem}:host(.expanded){background-color:var(--theme-color-ghost--active)}:host ::slotted(a[href]){text-decoration:none !important}";
const IxMenuCategoryStyle0 = menuCategoryCss;

const DefaultIxMenuItemHeight = 40;
const DefaultAnimationTimeout = 150;
const MenuCategory = class {
    constructor(hostRef) {
        index.registerInstance(this, hostRef);
        this.closeOtherCategories = index.createEvent(this, "closeOtherCategories", 7);
        this.enterLeaveDebounce = createEnterLeaveDebounce(() => {
            this.onPointerEnter();
        }, () => {
            this.onPointerLeave();
        });
        this.label = undefined;
        this.icon = undefined;
        this.notifications = undefined;
        this.menuExpand = false;
        this.showItems = false;
        this.showDropdown = false;
        this.nestedItems = [];
    }
    isNestedItemActive() {
        return this.getNestedItems().some((item) => item.active);
    }
    getNestedItems() {
        return Array.from(this.hostElement.querySelectorAll(':scope ix-menu-item'));
    }
    getNestedItemsHeight() {
        const items = this.getNestedItems();
        return items.length * DefaultIxMenuItemHeight;
    }
    onExpandCategory(showItems) {
        if (showItems) {
            this.animateFadeIn();
        }
        else {
            this.animateFadeOut();
        }
    }
    animateFadeOut() {
        const slotHideThresholdMs = 25;
        anime_es.anime({
            targets: this.menuItemsContainer,
            duration: DefaultAnimationTimeout,
            easing: 'easeInSine',
            opacity: [1, 0],
            maxHeight: [this.getNestedItemsHeight() + DefaultIxMenuItemHeight, 0],
            complete: () => {
                setTimeout(() => {
                    this.showItems = false;
                    this.showDropdown = false;
                }, DefaultAnimationTimeout + slotHideThresholdMs);
            },
        });
    }
    animateFadeIn() {
        anime_es.anime({
            targets: this.menuItemsContainer,
            duration: DefaultAnimationTimeout,
            easing: 'easeInSine',
            opacity: [0, 1],
            maxHeight: [0, this.getNestedItemsHeight() + DefaultIxMenuItemHeight],
            begin: () => {
                this.showItems = true;
                this.showDropdown = false;
            },
        });
    }
    onPointerEnter() {
        if (this.ixMenu.expand) {
            return;
        }
        this.closeOtherCategories.emit();
        this.showDropdown = true;
    }
    onPointerLeave() {
        this.showDropdown = false;
    }
    onCategoryClick(e) {
        e.stopPropagation();
        if (this.ixMenu.expand) {
            e === null || e === void 0 ? void 0 : e.stopPropagation();
            this.onExpandCategory(!this.showItems);
            return;
        }
    }
    onNestedItemsChanged() {
        this.nestedItems = this.getNestedItems();
    }
    isCategoryItemListVisible() {
        return this.menuExpand && (this.showItems || this.isNestedItemActive());
    }
    componentWillLoad() {
        const closestMenu = context.closestIxMenu(this.hostElement);
        if (!closestMenu) {
            throw Error('ix-menu-category can only be used as a child of ix-menu');
        }
        this.ixMenu = closestMenu;
        this.menuExpand = this.ixMenu.expand;
        this.showItems = this.isCategoryItemListVisible();
    }
    componentDidLoad() {
        this.observer = mutationObserver.createMutationObserver(() => this.onNestedItemsChanged());
        this.observer.observe(this.hostElement, {
            attributes: true,
            childList: true,
            subtree: true,
        });
        requestAnimationFrame(() => {
            this.onNestedItemsChanged();
        });
        this.ixMenu.addEventListener('expandChange', ({ detail: menuExpand }) => {
            this.menuExpand = menuExpand;
            if (!menuExpand) {
                this.clearMenuItemStyles();
            }
            this.showItems = this.isCategoryItemListVisible();
        });
    }
    clearMenuItemStyles() {
        this.menuItemsContainer.style.removeProperty('max-height');
        this.menuItemsContainer.style.removeProperty('opacity');
    }
    disconnectedCallback() {
        if (this.observer) {
            this.observer.disconnect();
        }
    }
    render() {
        return (index.h(index.Host, { key: '1c9a80de76eb1a08932e4065a5247312c175c44a', class: {
                expanded: this.showItems,
            }, onPointerEnter: () => {
                this.enterLeaveDebounce.onEnter();
            }, onPointerLeave: (event) => {
                if (event.pointerType === 'touch') {
                    return;
                }
                this.enterLeaveDebounce.onLeave();
            } }, index.h("ix-menu-item", { key: '4916e3fb2ef1c00ccf6a90366fb8e5ca1c7e4025', class: 'category-parent', active: this.isNestedItemActive(), notifications: this.notifications, icon: this.icon, onClick: (e) => this.onCategoryClick(e), onFocus: () => this.onPointerEnter(), isCategory: true }, index.h("div", { key: '1a27c0a36105ac449880ea3925e07d55d7a01f83', class: "category" }, index.h("div", { key: '7aec0b9d401d6167451907cb44a5b643ef07ac4b', class: "category-text" }, this.label), index.h("ix-icon", { key: '7e638930a4c9219cd7c86a9492ae5c0d336393c3', name: 'chevron-down-small', class: {
                'category-chevron': true,
                'category-chevron--open': this.showItems,
            } }))), index.h("div", { key: '609ce8e3554a871899c5c6c2cd2fad40224b59a8', ref: (ref) => (this.menuItemsContainer = ref), class: {
                'menu-items': true,
                'menu-items--expanded': this.showItems,
                'menu-items--collapsed': !this.showItems,
            } }, this.showItems ? index.h("slot", null) : null), index.h("ix-dropdown", { key: '1299830caade30d34fcfa03522546fe1a4b54296', closeBehavior: 'both', show: this.showDropdown, onShowChanged: ({ detail: dropdownShown }) => {
                this.showDropdown = dropdownShown;
            }, class: 'category-dropdown', anchor: this.hostElement, placement: "right-start", offset: {
                mainAxis: 3,
            }, onClick: (e) => {
                if (e.target instanceof HTMLElement) {
                    if (e.target.tagName === 'IX-MENU-ITEM') {
                        this.showDropdown = false;
                    }
                    else {
                        e.preventDefault();
                    }
                }
            } }, index.h("ix-dropdown-item", { key: '0a2f3039f44c9b545d29aef0ed3600188edbbaf2', class: 'category-dropdown-header' }, index.h("ix-typography", { key: '841736401537eb57c8446a9e86282d4f5eda900d', variant: "default-title-single", color: "std" }, this.label)), index.h("ix-divider", { key: '5bb1e9beec4f9fca106ccf24266bf16216dba34b' }), index.h("slot", { key: '8b0c28b1f92c96f93187373e2bef4bfe88156bfe' }))));
    }
    get hostElement() { return index.getElement(this); }
};
MenuCategory.style = IxMenuCategoryStyle0;

exports.ix_menu_category = MenuCategory;

//# sourceMappingURL=ix-menu-category.cjs.entry.js.map