/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
import { hasSlottedElements } from "../utils/shadow-dom";
/**
 * @since 2.1.0
 * @slot header - Display content at the top of the content page
 */
export class Content {
    constructor() {
        this.isContentHeaderSlotted = false;
    }
    get contentHeaderSlot() {
        return this.hostElement.shadowRoot.querySelector('.content-header slot');
    }
    render() {
        return (h(Host, { key: '61f9325ce908e838c83a286da21471c8f081cf7e' }, h("div", { key: '66adfdde8a6f7e4cec46bc8ac3111f9fd344462c', class: {
                'content-header': true,
                slotted: this.isContentHeaderSlotted,
            } }, h("slot", { key: '00a1dffb70b39ae24c7ffc7a02649f5c870e95e9', name: "header", onSlotchange: () => {
                this.isContentHeaderSlotted = hasSlottedElements(this.contentHeaderSlot);
            } })), h("div", { key: 'd27dfeb1305abb6cacdf16a5476e5d7b32d6f3ba', class: "content" }, h("slot", { key: '054a581bc21257f46c3377c53c0e8dbacc4321b5' }))));
    }
    static get is() { return "ix-content"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["content.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["content.css"]
        };
    }
    static get states() {
        return {
            "isContentHeaderSlotted": {}
        };
    }
    static get elementRef() { return "hostElement"; }
}
//# sourceMappingURL=content.js.map
