/*
 * SPDX-FileCopyrightText: 2023 Siemens AG
 *
 * SPDX-License-Identifier: MIT
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { h, Host } from "@stencil/core";
/**
 * @internal
 */
export class DateTimeCard {
    constructor() {
        this.standaloneAppearance = undefined;
        this.individual = true;
        this.corners = 'rounded';
    }
    cardClasses() {
        return {
            card: true,
            standaloneAppearance: this.standaloneAppearance !== undefined
                ? this.standaloneAppearance
                : this.individual,
            rounded: this.corners === 'rounded',
            left: this.corners === 'left',
            right: this.corners === 'right',
        };
    }
    render() {
        return (h(Host, { key: 'b699133fd52ef092307f90f515aa7046a99cd21f' }, h("div", { key: '938a7c031dae445fee084ea8c1390627b1743bfb', class: this.cardClasses() }, h("div", { key: '1d20df2d528d8219a7fcea504f63da8a07a4fe74', class: "header" }, h("slot", { key: '0dadc7cb6813210aa9de4299f86a2e1b8ed01764', name: "header" })), h("div", { key: '79a1560d676b4d7583edf9c2fc14be75d4a35514', class: "separator" }), h("div", { key: 'e0f633c51c1167383fc9f75d153cfb20ee77bc39', class: "content" }, h("slot", { key: 'eb8a5596284dd1a461d7f83abe3ec94ac0ebe76c' })))));
    }
    static get is() { return "ix-date-time-card"; }
    static get encapsulation() { return "shadow"; }
    static get originalStyleUrls() {
        return {
            "$": ["date-time-card.scss"]
        };
    }
    static get styleUrls() {
        return {
            "$": ["date-time-card.css"]
        };
    }
    static get properties() {
        return {
            "standaloneAppearance": {
                "type": "any",
                "mutable": false,
                "complexType": {
                    "original": "any",
                    "resolved": "any",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [{
                            "name": "internal",
                            "text": undefined
                        }],
                    "text": ""
                },
                "attribute": "standalone-appearance",
                "reflect": false,
                "defaultValue": "undefined"
            },
            "individual": {
                "type": "boolean",
                "mutable": false,
                "complexType": {
                    "original": "boolean",
                    "resolved": "boolean",
                    "references": {}
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "set styles"
                },
                "attribute": "individual",
                "reflect": false,
                "defaultValue": "true"
            },
            "corners": {
                "type": "string",
                "mutable": false,
                "complexType": {
                    "original": "DateTimeCardCorners",
                    "resolved": "\"left\" | \"right\" | \"rounded\" | \"straight\"",
                    "references": {
                        "DateTimeCardCorners": {
                            "location": "local",
                            "path": "/home/runner/work/ix/ix/packages/core/src/components/date-time-card/date-time-card.tsx",
                            "id": "src/components/date-time-card/date-time-card.tsx::DateTimeCardCorners"
                        }
                    }
                },
                "required": false,
                "optional": false,
                "docs": {
                    "tags": [],
                    "text": "Set corners style"
                },
                "attribute": "corners",
                "reflect": false,
                "defaultValue": "'rounded'"
            }
        };
    }
}
//# sourceMappingURL=date-time-card.js.map
